<?php
/**
* @package   BaForms
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Forms\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\Helper\BaformsHelper;
use Balbooa\Component\Forms\Administrator\Helper\Filesystem\File;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\Database\DatabaseInterface;

class DisplayController extends BaseController
{
    protected $default_view = 'forms';

    public function display($cachable = false, $urlparams = false) 
    {
        BaformsHelper::prepare();
        $develop = $this->input->get('develop', '', 'string');
        if ($develop == 'refreshDB') {
            $this->refreshDB();
        }

        parent::display($cachable, $urlparams);
    }

    static function refreshDB(): never
    {
        $path = JPATH_COMPONENT . '/installation/test.sql';
        $str = File::read($path);
        $db = Factory::getContainer()->get(DatabaseInterface::class);
        $queries = $db->splitSql($str);
        foreach ($queries as $query) {
            $db->setQuery($query)
                ->execute();
        }

        dd('Database Refreshed');
    }
}