<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Administrator\Helper\Filter\Filters;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\Helper\Filter\Abstracts\ItemFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Enum\FilterEnum;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Interface\FilterInterface;

class InputFilter extends ItemFilter implements FilterInterface
{
    protected array $optionsRules = [
        "title" => FilterEnum::String,
        "description" => FilterEnum::String,
        "placeholder" => FilterEnum::String,
        "icon" => FilterEnum::String,
        "type" => FilterEnum::String,
        "default" => FilterEnum::QuotedString,
        "validation" => FilterEnum::String,
        "mask" => FilterEnum::String,
        "suffix" => FilterEnum::String,
        "required" => FilterEnum::Boolean,
        "readonly" => FilterEnum::Boolean,
        "hidden" => FilterEnum::Boolean
    ];

    protected array $charactersRules = [
        "length" => FilterEnum::String,
        "key" => FilterEnum::String,
    ];

    protected array $confirmRules = [
        "enable" => FilterEnum::Boolean,
        "title" => FilterEnum::String,
        "description" => FilterEnum::String,
        "placeholder" => FilterEnum::String,
        "icon" => FilterEnum::String,
        "default" => FilterEnum::String,
    ];

    public function clean(object &$data): void
    {
        parent::clean($data);

        $this->cleanOptionProperty($data, 'characters', $this->charactersRules);
        $this->cleanOptionProperty($data, 'confirm', $this->confirmRules);
        $this->cleanOptionProperty($data, 'confirm-password', $this->confirmRules);
    }
}