<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Administrator\Helper\Filter\Filters;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\Helper\Filter\Abstracts\ItemFilter;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Enum\FilterEnum;
use Balbooa\Component\Forms\Administrator\Helper\Filter\Interface\FilterInterface;

class TotalFilter extends ItemFilter implements FilterInterface
{
    protected array $optionsRules = [
        "title" => FilterEnum::String,
        "description" => FilterEnum::String,
        "position" => FilterEnum::String,
        "separator" => FilterEnum::String,
        "symbol" => FilterEnum::String,
        "code" => FilterEnum::String,
        "thousand" => FilterEnum::String,
        "suffix" => FilterEnum::String,
        "cart" => FilterEnum::Boolean,
        "decimals" => FilterEnum::Integer,
    ];

    protected array $taxRules = [
        "enable" => FilterEnum::Boolean,
        "title" => FilterEnum::String,
        "value" => FilterEnum::String,
    ];

    protected array $promoRules = [
        "enable" => FilterEnum::Boolean,
        "code" => FilterEnum::String,
        "discount" => FilterEnum::String,
        "unit" => FilterEnum::String,
        "expires" => FilterEnum::String,
    ];

    public function clean(object &$data): void
    {
        parent::clean($data);

        $this->cleanOptionProperty($data, 'promo', $this->promoRules);
        $this->cleanOptionProperty($data, 'tax', $this->taxRules);
    }
}