<?php
/**
* @package   GRIDBOX
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Forms\Administrator\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

abstract class HtmlStatesHelper
{
    protected static array $states = [
        [
            'task' => 'publish',
            'title' => 'JUNPUBLISHED'
        ],
        [
            'task' => 'unpublish',
            'title' => 'JPUBLISHED'
        ]
    ];

    public static function disabled(): string
    {
        return <<<HTML
            <a class="disabled" href="javascript:void(0);">
                <i class="zmdi zmdi-eye ba-icon-md"></i>
            </a>
        HTML;
    }

    public static function published(
        int $value,
        int $i,
        string $prefix = '',
        bool $enabled = true
    ): string {
        if (!$enabled) {
            return self::disabled();
        }

        $state = self::$states[$value];
        $task = $prefix . $state['task'];
        $text = Text::_($state['title']);
        $icon = $state['task'] != 'publish' ? 'zmdi zmdi-eye' : 'zmdi zmdi-eye-off';

        return <<<HTML
            <a href="javascript:void(0);"
                onclick="return Joomla.listItemTask('cb$i', '$task');">
                <i class="$icon ba-icon-md"></i>
                <span class="ba-tooltip ba-hide-element ba-top">$text</span>
            </a>
        HTML;
    }
}