<?php
/**
* @package   BaForms
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Forms\Administrator\Model;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\Helper\BaformsHelper;
use Balbooa\Component\Forms\Administrator\Helper\Filesystem\File;
use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
 
class SubmissionModel extends AdminModel
{
    public function getTable($type = 'Submissions', $prefix = 'Administrator', $config = array())
    {
        return parent::getTable($type, $prefix, $config);
    }

    public function deleteFiles($cid)
    {
        $db = $this->getDatabase();
        foreach ($cid as $id) {
            $this->deleteFile($id, $db);
        }
    }

    public function deleteFile($id, $db)
    {
        $query = $db->getQuery(true)
            ->select('id, filename')
            ->from('#__baforms_submissions_attachments')
            ->where('submission_id = '.$id);
        $db->setQuery($query);
        $files = $db->loadObjectList();
        foreach ($files as $file) {
            $this->removeTmpAttachment($file->id, $file->filename, 0);
        }
    }

    public function contextDelete($id)
    {
        $db = $this->getDatabase();
        $this->deleteFile($id, $db);
        $query= $db->getQuery(true)
            ->delete('#__baforms_submissions')
            ->where('id = '.$id);
        $db->setQuery($query)
            ->execute();
    }

    public function removeTmpAttachment($id, $filename, $submission)
    {
        if (!empty($id) && !empty($filename)) {
            $db = $this->getDatabase();
            $query = $db->getQuery(true)
                ->select('*')
                ->from('#__baforms_submissions_attachments')
                ->where('id = '.$id);
            $db->setQuery($query);
            $file = $db->loadObject();
            $target = JPATH_ROOT.'/'.BaformsHelper::$uploads_storage.'/form-'.$file->form_id.'/'.$file->filename;
            if (File::exists($target)) {
                File::delete($target);
            }
            $query = $db->getQuery(true)
                ->delete('#__baforms_submissions_attachments')
                ->where('id = '.$id);
            $db->setQuery($query)
                ->execute();
        } else if (empty($id) && !empty($filename)) {
            $params = ComponentHelper::getParams('com_baforms');
            $uploaded_path = $params->get('uploaded_path', 'images');
            $target = JPATH_ROOT.'/'.$uploaded_path.'/baforms/'.$filename;
            if (File::exists($target)) {
                File::delete($target);
            }
            $db = $this->getDatabase();
            $query = $db->getQuery(true)
                ->select('*')
                ->from('#__baforms_submissions')
                ->where('id = '.$submission);
            $db->setQuery($query);
            $obj = $db->loadObject();
            $message = explode('_-_', $obj->message);
            $array = array();
            foreach ($message as $value) {
                $item = explode('|-_-|', $value);
                if (empty($item[0]) || !($item[2] == 'upload' && $item[1] == $filename)) {
                    $array[] = $value;
                }
            }
            $obj->message = implode('_-_', $array);
            $db->updateObject('#__baforms_submissions', $obj, 'id');
        }
    }

    public function getFiles($id)
    {
        $db = $this->getDatabase();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__baforms_submissions_attachments')
            ->where('submission_id = '.$id);
        $db->setQuery($query);
        $files = $db->loadObjectList();
        $items = new \stdClass();
        foreach ($files as $file) {
            if (!isset($items->{$file->field_id})) {
                $query = $db->getQuery(true)
                    ->select('*')
                    ->from('#__baforms_items')
                    ->where('id = '.$file->field_id);
                $db->setQuery($query);
                $field = $db->loadObject();
                $obj = new \stdClass();
                if (!empty($field->options)) {
                    $params = json_decode($field->options);
                    $obj->title = $params->title ?? '';
                } else {
                    $obj->title = 'Upload file button';
                }
                $obj->files = array();
                $items->{$file->field_id} = $obj;
            }
            $items->{$file->field_id}->files[] = $file;
        }

        return $items;
    }

    public function getMessage($id)
    {
        $result = BaformsHelper::getSubmission($id);

        return $result;
    }
    
    public function getForm($data = [], $loadData = true)
    {
        
        $form = $this->loadForm($this->option . '.submissions', 'submissions', array('control' => 'jform', 'load_data' => $loadData)); 
        if (empty($form)) {
            return false;
        }
 
        return $form;
    }

    public function readAll()
    {
        $db = $this->getDatabase();
        $query = $db->getQuery(true)
            ->update('#__baforms_submissions')
            ->set('submission_state = 0');
        $db->setQuery($query)
            ->execute();
    }
    
    public function setReadStatus($id, $state = 0)
    {
        $db = $this->getDatabase();
        $obj = new \stdClass();
        $obj->id = $id;
        $obj->submission_state = $state;
        $db->updateObject('#__baforms_submissions', $obj, 'id');
    }    
}