<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Administrator\View\Contracts;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\Helper\ExtensionInfo;
use Joomla\CMS\User\User;
use Joomla\CMS\WebAsset\WebAssetManager;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\CMS\Uri\Uri;

abstract class BaseView extends HtmlView
{
    protected object $about;
    protected User $user;
    protected WebAssetManager $wa;

    protected function beforeDisplay(): void
    {
        $this->initializeView();
        $this->registerAssets();
    }

    protected function initializeView(): void
    {
        $this->user = $this->getCurrentUser();
        $this->about = ExtensionInfo::get();
        $this->wa = $this->getDocument()->getWebAssetManager();
    }

    protected function registerAssets(): void
    {
        $this->wa->registerAndUseScript('com_baforms.jquery', Uri::root().'/media/vendor/jquery/js/jquery.min.js');
    }
}