<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Administrator\View\Contracts;

defined('_JEXEC') or die;

use Joomla\CMS\Uri\Uri;

abstract class ListView extends BaseView
{
    protected array $items;
    protected ?object $pagination;
    protected ?object $state;

    protected function prepareListData(): void
    {
        $this->items = $this->get('Items');
        $this->pagination = $this->get('Pagination');
        $this->state = $this->get('State');
        $this->addToolBar();
    }

    protected function registerAssets(): void
    {
        $this->wa->useScript('list-view');
        $this->wa->registerAndUseStyle('com_baforms.material', Uri::root().'/components/com_baforms/assets/icons/material/material.css');
        $this->wa->registerAndUseStyle('com_baforms.admin', 'components/com_baforms/assets/css/ba-admin.css?'.$this->about->version);
        parent::registerAssets();
    }
}