<?php
/**
* @package   BaForms
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Forms\Administrator\View\Forms;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\View\Contracts\ListView;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;

class HtmlView extends ListView
{
    public function display($tpl = null)
    {
        $this->beforeDisplay();
        $this->prepareListData();
        
        parent::display($tpl);
    }
    
    protected function addToolBar(): void
    {
        ToolBarHelper::title(Text::_('FORMS'), 'star');
        if ($this->user->authorise('core.duplicate', 'com_baforms')) {
            ToolBarHelper::custom('forms.duplicate', 'copy.png', 'copy_f2.png', 'JTOOLBAR_DUPLICATE', true);
        }
        if ($this->user->authorise('core.edit.state', 'com_baforms')) {
            ToolBarHelper::publish('forms.publish', 'JTOOLBAR_PUBLISH', true);
            ToolBarHelper::unpublish('forms.unpublish', 'JTOOLBAR_UNPUBLISH', true);
        }
        ToolBarHelper::custom('forms.export', 'download.png', 'download.png', 'EXPORT');
        if ($this->user->authorise('core.delete', 'com_baforms')) {
            ToolBarHelper::trash('forms.trash');
        }
    }
}