<?php
/**
* @package   BaForms
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Forms\Administrator\View\Submissions;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\View\Contracts\ListView;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Component\ComponentHelper;

class HtmlView extends ListView
{
    protected string $uploaded_path;
    protected object $submission;
    protected array $titles;

    public function display($tpl = null) 
    {
        $this->beforeDisplay();
        $input = Factory::getApplication()->input;
        $layout = $input->get('layout', '');
        if ($layout == 'pdf' || $layout == 'print') {
            $this->submission = $this->get('Submission');
        }
        if (empty($layout)) {
            $this->titles = $this->get('SubmissionForms');
            $this->prepareListData();
        }


        parent::display($tpl);
    }

    protected function registerAssets(): void
    {
        parent::registerAssets();
        $params = ComponentHelper::getParams('com_baforms');
        $this->uploaded_path = $params->get('uploaded_path', 'images');
        $this->wa->addInlineScript('var uploaded_path = "'.$this->uploaded_path.'";');
    }

    protected function addToolBar(): void
    {
        ToolbarHelper::title(Text::_('SUBMISSIONS'), 'star');
        ToolbarHelper::custom('submissions.export', 'download.png', 'download.png', 'EXPORT', true);
        if ($this->user->authorise('core.delete', 'com_baforms')) {
            ToolbarHelper::deleteList('', 'submissions.delete');
        }
        ToolbarHelper::custom('submissions.readAll', 'eye.png', 'eye.png', 'MARK_ALL_AS_READ', false);
        ToolbarHelper::custom('submissions.unread', 'eye-slash.png', 'eye-slash.png', 'MARK_AS_UNREAD', true);
    }
}