<?php
/**
* @package   BaForms
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Forms\Administrator\View\Trashed;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\View\Contracts\ListView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;

class HtmlView extends ListView
{
    public function display($tpl = null)
    {
        $this->beforeDisplay();
        $this->prepareListData();
        
        parent::display($tpl);
    }
    
    protected function addToolBar(): void
    {
        ToolBarHelper::title(Text::_('TRASHED_ITEMS'), 'star');
        if ($this->user->authorise('core.edit.state', 'com_baforms')) {
            ToolBarHelper::custom('forms.restore', 'undo-2.png', 'undo-2.png', 'RESTORE', true);
        }
        if ($this->user->authorise('core.delete', 'com_baforms')) {
            ToolBarHelper::deleteList('', 'forms.delete');
        }
    }
}