<?php
/**
* @package   BaForms
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Forms\Administrator\View\Uploader;

defined('_JEXEC') or die;

use Balbooa\Component\Forms\Administrator\Helper\BaformsHelper;
use Balbooa\Component\Forms\Administrator\View\Contracts\BaseView;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

class HtmlView extends BaseView
{
    protected $_folders;
    protected $_images;
    protected $_items;
    protected $_parent;
    protected $_list;
    protected $_breadcrumb;
    protected $_move_to = [];
    protected $_page = 0;
    protected $_pages = 1;
    protected $_limit = 25;
    protected $_imagesExt;
    protected $fileTypes;
    protected $folder;
    protected $visibleBranch;
    
    public function display ($tpl = null)
    {
        $this->beforeDisplay();
        if (!$this->user->authorise('core.edit', 'com_baforms')) {
            throw new \Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
        }
        if (count($errors = $this->get('Errors'))) {
            throw new \Exception(implode('<br />', $errors), 500);
        }
        $this->_folders = $this->get('Folders');
        $this->_images = $this->get('Images');
        $this->_items = array_merge($this->_folders, $this->_images);
        $this->_imagesExt = ['jpg', 'png', 'gif', 'jpeg', 'svg', 'ico', 'webp'];
        $this->_parent = $this->get('parent');
        $this->folder = '';
        $this->addToolBar();
        $this->drawPagination();
        if (is_array($this->_folders)) {
            $this->_breadcrumb = $this->get('Breadcrumb');
            $this->visibleBranch = new \stdClass();
            foreach ($this->_breadcrumb as $value) {
                $this->visibleBranch->{$value->path} = true;
            }
        }
        if (!$this->user->authorise('core.edit', 'com_baforms')) {
            throw new \Exception(Text::_('NOT_FOUND'), 404);
        }
        $this->_list = $this->get('FolderList');
        $this->_list = $this->drawFolderList($this->_list);
        parent::display($tpl);
    }

    protected function registerAssets(): void
    {
        $this->fileTypes = $this->get('fileTypes');
        $this->wa->registerAndUseScript('com_baforms.bootstrap', Uri::root().'administrator/components/com_baforms/assets/libraries/bootstrap/bootstrap.js');
        $this->wa->addInlineScript('var $fileTypes = '.json_encode($this->fileTypes).', IMAGE_PATH = "'.BaformsHelper::$image_path.'";');

        parent::registerAssets();
    }

    protected function drawPagination()
    {
        $input = Factory::getApplication()->input;
        $page = $input->get('page', '', 'string');
        if (!empty($page)) {
            $this->_page = $page * 1;
        }
        $limit = $input->get('ba_limit', '', 'string');
        if (!$limit) {
            $limit = 25;
        }
        $this->_limit = $limit;
        $count = count($this->_items);
        $this->_pages = ceil($count / $limit);
        if ($limit == 1) {
            $this->_pages = 1;
        }
        if ($this->_pages > 1) {
            $this->_items = array_slice($this->_items, $this->_page * $limit, $limit);
        }
    }

    protected function drawFolderList($list)
    {
        $str = '<ul>';
        $input = Factory::getApplication()->input;
        $layout = $input->get('layout', '', 'layout');
        foreach ($list as $value) {
            $str .= '<li data-path="'.$value->path.'"';            
            $className = '';
            if ($this->_parent == JPATH_ROOT.'/'.BaformsHelper::$image_path.$value->path) {
                $this->folder = $value->path;
                $className .= ' active';
            }
            if (isset($this->visibleBranch->{$value->path})) {
                $className .= ' visible-branch';
            }
            $str .= ' class="'.$className.'"';
            $str .= '><a data-href="folder='.$value->path;
            if ($layout == 'thubnail') {
                $str .= '&layout=thubnail';
            }
            $str .= '&tmpl=component" ><i class="zmdi zmdi-folder"></i> '.$value->name.'</a>';
            if (count($value->childs) > 0) {
                $str .= '<i class="zmdi zmdi-chevron-right"></i>';
                $str .= $this->drawFolderList($value->childs);
            }
            $str .= '</li>';
        }
        $str .= '</ul>';

        return $str;
    }

    protected function getFileSize($size)
    {
        $size = $size / 1024;
        $size = floor($size);
        if ($size >= 1024) {
            $size = $size / 1024;
            $size = floor($size);
            $size = (string)$size .' MB';
        } else {
            $size = (string)$size .' KB';
        }

        return $size;
    }

    protected function addToolBar()
    {
        $input = Factory::getApplication()->input;
        $input->set('hidemainmenu', true);
    }
}