<?php
/**
 * @package   BaForms
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Forms\Site\Helper\Captcha;

defined('_JEXEC') or die;

class CaptchaFactory
{
    public static function make(string $type): ?FormsCaptcha
    {
        return match (strtolower($type)) {
            GoogleRecaptcha::getType() => GoogleRecaptcha::getInstance(),
            HCaptcha::getType() => HCaptcha::getInstance(),
            TurnstileCaptcha::getType() => TurnstileCaptcha::getInstance(),
            default => null,
        };
    }
}