/**
* @package   Gallery
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

function showNotice(message, className, callback)
{
    if (!className) {
        className = '';
    }
    if (notification.hasClass('notification-in')) {
        setTimeout(function(){
            notification.removeClass('notification-in').addClass('animation-out');
            setTimeout(function(){
                addNoticeText(message, className, callback);
            }, 400);
        }, 2000);
    } else {
        addNoticeText(message, className, callback);
    }
}

function addNoticeText(message, className, callback)
{
    let time = className ? 6000 : 3000;
    notification.find('p').html(message);
    notification.addClass(className).removeClass('animation-out').addClass('notification-in');
    setTimeout(function(){
        notification.removeClass('notification-in').addClass('animation-out');
        if (callback) {
            callback.call();
        }
        setTimeout(function(){
            notification.removeClass(className);
        }, 400);
    }, time);
}

var notification = null;

class GalleryRequest
{
    static async handle(url, data, isFile)
    {
        const request = await fetch(url, {
            method: 'POST',
            body: this.getBody(data, isFile)
        });
        const text = await request.text();

        return text;
    }

    static getBody(data, isFile)
    {
        const formData = new FormData();
        if (!data) {
            return formData;
        }

        for (let ind in data) {
            if (Array.isArray(data[ind])) {
                data[ind].forEach(function(v){
                    formData.append(`${ind}[]`, v);
                })
            } else if (!isFile && typeof data[ind] == 'object') {
                for (let i in data[ind]) {
                    formData.append(`${ind}[${i}]`, data[ind][i]);
                }
            } else {
                formData.append(ind, data[ind]);
            }
        }

        return formData;
    }
}

class GalleryText
{
    static _(key){
        if (!galleryLanguage || !galleryLanguage[key]) {
            return key;
        }

        return galleryLanguage[key];
    }
}

class GalleryXmlHelper
{
    static dialog = null;
    static importFile = null
    static applyImportBtn = null;
    static url = 'index.php?option=com_gallery&task=galleries.';

    static exportSelected()
    {
        const pks = Array.from(document.querySelectorAll('.table-striped tbody input[type="checkbox"]'))
            .filter(input => input.checked).map(input => input.value);
        this.export(pks);
    }

    static export(pks)
    {
        GalleryRequest.handle(`${this.url}export`, {
            cid: pks
        }).then(text => {
            const response = JSON.parse(text);
            this.download(response.message)
        })
    }

    static download(file)
    {
        const iframe = document.createElement('iframe');
        iframe.id = 'download-iframe';
        iframe.style.display = 'none';
        iframe.src = `${this.url}download&file=${file}`;
        document.querySelector('#download-target')?.remove();
        document.body.append(iframe);
    }

    static triggerImportFile()
    {
        this.importFile.trigger('click');
    }

    static isXmlFile(name)
    {
        return name.toLowerCase().endsWith('.xml');
    }

    static checkImportFile(event)
    {
        const input = event.target;
        if (input.files.length == 0) {
            return;
        }
        const name = input.files[0].name;
        this.dialog.find('input.file-trigger').val(name);
        if (this.isXmlFile(name)) {
            this.applyImportBtn.addClass('active-button');
        } else {
            showNotice(GalleryText._('IMPORT_UPLOAD_ERROR'), 'ba-alert');
            this.applyImportBtn.removeClass('active-button');
        }
    }

    static applyImport(event)
    {
        event.preventDefault();
        if (!this.applyImportBtn.hasClass('active-button')) return;

        const imagePath = 'components/com_gallery/assets/images/reload.svg'
        const installing = `${GalleryText._('INSTALLING')}<img src="${imagePath}">`;
        notification[0].className = 'notification-in';
        notification.find('p').html(installing);
        this.dialog.modal('hide');
        this.import()
    }

    static import()
    {
        GalleryRequest.handle(`${this.url}import`, {
            file: this.importFile[0].files[0],
        }, true).then(text => {
            showNotice(GalleryText._('SUCCESS_UPLOAD'), '', () => {
                window.location.reload();
            });
        })
    }

    static setImportElements()
    {
        this.dialog = jQuery('#import-dialog');
        this.importFile = this.dialog.find('#import-file');
        this.applyImportBtn = this.dialog.find('.apply-import');
    }

    static setImportEvents()
    {
        if (this.dialog) return;

        this.setImportElements();
        this.dialog.find('.file-trigger').on('click', this.triggerImportFile.bind(this));
        this.importFile.on('change', this.checkImportFile.bind(this));
        this.applyImportBtn.on('click', this.applyImport.bind(this));
    }

    static showImportDialog()
    {
        this.setImportEvents();
        this.dialog.modal();
    }
}

class ContextMenu
{
    static menu = null;
    static item = null;

    static setPosition(top, left)
    {
        const deltaX = document.documentElement.clientWidth - left;
        const deltaY = document.documentElement.clientHeight - top;
        const isLeft = deltaX - this.menu.offsetWidth < 0;
        const isTop = deltaY - this.menu.offsetHeight < 0;
        this.menu.style.top = `${top}px`;
        this.menu.style.left = `${left}px`;
        this.menu.classList[isLeft ? 'add' : 'remove']('ba-left');
        this.menu.classList[isTop ? 'add' : 'remove']('ba-top');
    }

    static show(event, menu, item)
    {
        event.stopPropagation();
        event.preventDefault();

        this.hide()
        if (!menu) return;

        this.item = item;
        this.menu = menu;
        item.classList.add('context-active');
        setTimeout(() => {
            this.menu.style.display = '';
            this.setPosition(event.clientY, event.pageX);
        }, 50);
    }

    static hide()
    {
        if (this.menu) {
            this.menu.style.display = 'none';
            this.menu = null;
        }
        if (this.item) {
            this.item.classList.remove('context-active');
        }
    }
}

class GalleryDesignHelper
{
    static design = localStorage.getItem('galleryDesign');

    static copy()
    {
        GalleryRequest.handle('index.php?option=com_gallery&task=galleries.getDesign', {
            id: ContextMenu.item.querySelector('.form-check-input[name="cid[]"]').value
        }).then(text => {
            localStorage.setItem('galleryDesign', text);
            GalleryDesignHelper.design = text;
        });
    }

    static paste(event)
    {
        if (event.target.closest('span').classList.contains('disable-button')) {
            return;
        }
        GalleryRequest.handle('index.php?option=com_gallery&task=galleries.pasteDesign', {
            id: ContextMenu.item.querySelector('.form-check-input[name="cid[]"]').value,
            design: GalleryDesignHelper.design
        }).then(text => {
            showNotice(text);
        });
    }

    static setEvents()
    {
        document.querySelector('.context-copy-style').addEventListener('click', this.copy);
        document.querySelector('.context-paste').addEventListener('click', this.paste);
    }
}

document.addEventListener('DOMContentLoaded', function(){

    Joomla.submitbutton = function(task){
        if (task == 'galleries.export') {
            GalleryXmlHelper.exportSelected();
        } else if (task == 'galleries.import') {
            GalleryXmlHelper.showImportDialog();
        } else {
            Joomla.submitform(task);
        }
    }
    GalleryDesignHelper.setEvents();

    notification = jQuery('#ba-notification');

    var massage = '';

    setTimeout(function(){
        jQuery('.alert.alert-success').addClass('animation-out');
    }, 2000);

    jQuery('.context-duplicate').on('click', function(){
        GalleryRequest.handle('index.php?option=com_gallery&task=galleries.duplicate', {
            cid: [ContextMenu.item.querySelector('.form-check-input[name="cid[]"]').value]
        }).then(_ => {
            showNotice(GalleryText._('GALLERY_DUPLICATED'), '', () => {
                window.location.reload()
            })
        });
    });

    jQuery('.context-export').on('click', function (){
        const pks = [ContextMenu.item.querySelector('.form-check-input[name="cid[]"]').value];
        GalleryXmlHelper.export(pks);
    });

    jQuery('.context-trash').on('click', function(){
        const pks = [ContextMenu.item.querySelector('.form-check-input[name="cid[]"]').value];
        const token = Joomla.getOptions('csrf.token');
        GalleryRequest.handle('index.php?option=com_gallery&task=galleries.trash', {
            cid: pks,
            [token] : 1
        }).then(_ => {
            showNotice(GalleryText._('COM_GALLERY_N_ITEMS_TRASHED'), '', () => {
                window.location.reload()
            })
        });
    });

    jQuery('.context-delete').on('click', function(){
        const pks = [ContextMenu.item.querySelector('.form-check-input[name="cid[]"]').value];
        const token = Joomla.getOptions('csrf.token');
        GalleryRequest.handle('index.php?option=com_gallery&task=galleries.delete', {
            cid: pks,
            [token] : 1
        }).then(_ => {
            showNotice(GalleryText._('COM_GALLERY_N_ITEMS_DELETED'), '', () => {
                window.location.reload()
            });
        });
    });

    jQuery('body').on('click', '#toolbar-cleanup-images', function(){
        jQuery('#cleanup-images-dialog').modal();
    }).on('contextmenu', '.main-table tbody tr', function(event){
        const menu = document.querySelector('.galleries-context-menu');
        const action = GalleryDesignHelper.design ? 'remove' : 'add';
        menu.querySelector('.context-paste').classList[action]('disable-button');
        ContextMenu.show(event, menu, this);
    });

    jQuery('#cleanup-images').on('click', function(){
        var str = GalleryText._('SAVING')+'<img src="'+JUri;
        str += 'administrator/components/com_gallery/assets/images/reload.svg"></img>';
        notification.addClass('notification-in');
        notification.find('p').html(str);
        jQuery.ajax({
            type:"POST",
            dataType:'text',
            url:"index.php?option=com_gallery&task=galleries.cleanup&tmpl=component",
            success: function(msg){
                showNotice(msg);
            }
        });
        jQuery('#cleanup-images-dialog').modal('hide');
    });

    jQuery('.ba-custom-select > i, div.ba-custom-select input').on('click', function(event){
        event.stopPropagation()
        var parent = jQuery(this).parent();
        jQuery('.visible-select').removeClass('visible-select');
        parent.find('ul').addClass('visible-select');
        parent.find('li').off('click').one('click', function(){
            var text = jQuery.trim(jQuery(this).text()),
                val = jQuery(this).attr('data-value');
            parent.find('input[type="text"]').val(text);
            parent.find('input[type="hidden"]').val(val).trigger('change');
        });
        parent.trigger('show');
        setTimeout(function(){
            jQuery('body').one('click', function(){
                jQuery('.visible-select').removeClass('visible-select');
            });
        }, 50);
    });

    jQuery('.ba-tooltip').each(function(){
        jQuery(this).parent().on('mouseenter', function(){
            var tooltip = jQuery(this).find('.ba-tooltip'),
                coord = this.getBoundingClientRect(),
                top = coord.top,
                data = tooltip.html(),
                center = (coord.right - coord.left) / 2;
                className = tooltip[0].className;
            center = coord.left + center;
            if (tooltip.hasClass('ba-bottom')) {
                top = coord.bottom;
            }
            jQuery('body').append('<span class="'+className+'">'+data+'</span>');
            var tooltip = jQuery('body > .ba-tooltip').last(),
                width = tooltip.outerWidth(),
                height = tooltip.outerHeight();
            if (tooltip.hasClass('ba-top') || tooltip.hasClass('ba-help')) {
                top -= (15 + height);
                center -= (width / 2)
            }
            if (tooltip.hasClass('ba-bottom')) {
                top += 10;
                center -= (width / 2)
            }
            tooltip.css({
                'top' : top+'px',
                'left' : center+'px'
            }).on('mousedown', function(event){
                event.stopPropagation();
            });
        }).on('mouseleave', function(){
            var tooltip = jQuery('body').find(' > .ba-tooltip');
            tooltip.addClass('tooltip-hidden');
            setTimeout(function(){
                tooltip.remove();
            }, 500);
        });
    });

    jQuery('div.ba-custom-select').on('show', function(){
        jQuery(this).find('i.zmdi.zmdi-check').parent().addClass('selected');
    });

    jQuery('.ba-dashboard-apps-dialog').on('click', function(event){
        event.stopPropagation();
    });
    jQuery('body').on('click', function(){
        ContextMenu.hide();
        jQuery('.ba-dashboard-apps-dialog.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
    }).on('click', '.ba-dashboard-popover-trigger', function(event){
        event.stopPropagation();
        let div = document.querySelector('.'+this.dataset.target),
            rect = this.getBoundingClientRect();
        div.classList.add('visible-dashboard-dialog');
        let left = (rect.left - div.offsetWidth / 2 + rect.width / 2),
            arrow = '50%';
        div.style.setProperty('--arrow-position', arrow);
        div.style.top = (rect.bottom + window.pageYOffset + 10)+'px';
        div.style.left = left+'px';
    });

    GalleryLicense.loadApi();
});

class GalleryActivationHelper
{
    static deactivationDialog = null;

    static activate(event)
    {
        event.preventDefault();
        jQuery('.ba-dashboard-about.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
        LoginDialog.show('activateGallery');
    }

    static showDeactivationDialog(event)
    {
        event.preventDefault();
        if (!this.deactivationDialog) {
            this.deactivationDialog = jQuery('#deactivate-dialog');
        }
        jQuery('.ba-dashboard-about.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
        this.deactivationDialog.modal();
    }

    static setAppLicense()
    {
        const url = `${JUri}index.php?option=com_gallery&task=gallery.setAppLicense`;
        GalleryRequest.handle(url).then(_ => {
            showNotice(GalleryText._('SUCCESSFULY_DEACTIVATED'));
            jQuery('#toolbar-about span[data-notification]').each(function(){
                this.dataset.notification = this.dataset.notification * 1 + 1;
            });
            jQuery('.gallery-activate-license').css('display', '');
            jQuery('.gallery-deactivate-license').hide();
        })
    }

    static deactivate(event)
    {
        event.preventDefault();
        const url = "index.php?option=com_gallery&task=galleries.checkGalleryState"
        GalleryRequest.handle(url).then(text => {
            const obj = JSON.parse(text);
            const time = Date.now();
            const script = document.createElement('script');
            script.onload = this.setAppLicense;
            script.src = `${GalleryLicense.getUrl('bagallery.deactivateLicense')}&data=${obj.data}&time=${time}`;
            document.head.appendChild(script);
        })

        this.deactivationDialog.modal('hide');
    }

    static setEvents()
    {
        jQuery('.activate-link').on('click', this.activate.bind(this));
        jQuery('.deactivate-link').on('click', this.showDeactivationDialog.bind(this));
        jQuery('#apply-deactivate').on('click', this.deactivate.bind(this));
    }
}

class GalleryUpdater
{
    static url = 'index.php?option=com_gallery&task=galleries.checkGalleryState';

    static update()
    {
        setTimeout(function(){
            let str = GalleryText._('UPDATING')+'<img src="'+JUri;
            str += 'administrator/components/com_gallery/assets/images/reload.svg"></img>';
            notification[0].className = 'notification-in';
            notification.find('p').html(str);
        }, 400);
        GalleryLicense.load('package', () => {
            const XHR = new XMLHttpRequest();
            const url = 'index.php?option=com_gallery&task=galleries.updateGallery';
            const data = {
                method: window.atob('YmFzZTY0X2RlY29kZQ=='),
                package: galleryApi.package
            };
            XHR.onreadystatechange = function() {
                if (XHR.readyState == 4) {
                    showNotice(GalleryText._('UPDATED'), '', () => {
                        window.location.reload();
                    });
                }
            };
            XHR.open("POST", url, true);
            XHR.send(JSON.stringify(data));
        })
    }

    static tryUpdate(text)
    {
        let flag = true,
            obj;
        if (text) {
            obj = JSON.parse(text);
            flag = !obj.data;
        }
        if (flag) {
            LoginDialog.show('updateGallery');
            return;
        }
        const script = document.createElement('script');
        script.onload = () => {
            if (galleryResponse) {
                GalleryUpdater.update();
            } else {
                LoginDialog.show('updateGallery');
            }
        }
        script.src = `${GalleryLicense.getUrl('bagallery.checkGalleryUser')}&data=${obj.data}`;
        document.head.append(script);
    }

    static setEvents()
    {
        jQuery('.gallery-update-wrapper').on('click', '.update-link', (event) => {
            event.preventDefault();
            jQuery('.ba-dashboard-about.visible-dashboard-dialog').removeClass('visible-dashboard-dialog');
            GalleryRequest.handle(this.url).then(this.tryUpdate);
        });
    }
}

class LoginDialog
{
    static dialog = this.getDialog();

    static getDialog()
    {
        return jQuery('#login-modal');
    }

    static onShow()
    {
        const iframe = document.createElement('iframe');
        iframe.onload = function(){
            this.classList.add('iframe-loaded');
        }
        iframe.src = GalleryLicense.getUrl();
        this.dialog.find('.modal-body').html(iframe);
        window.addEventListener("message", this.listen, false);
    }

    static onHide()
    {
        window.removeEventListener("message", this.listen, false);
    }

    static listen(event)
    {
        if (event.origin != 'https://www.balbooa.com') {
            return;
        }
        try {
            let obj = JSON.parse(event.data);
            LoginDialog.getUserLicense(obj.data);
            if (LoginDialog.action == 'updateGallery') {
                GalleryUpdater.update();
            }
        } catch (error) {
            showNotice(event.data, 'ba-alert');
        }
        LoginDialog.dialog.modal('hide');
    }

    static show(action)
    {
        this.action = action;
        this.dialog.modal();
    }

    static getUserLicense(data)
    {
        GalleryRequest.handle("index.php?option=com_gallery&task=galleries.getUserLicense", {
            data: data
        }).then(_ => {
            if (this.action != 'updateGallery') {
                showNotice(GalleryText._('YOUR_LICENSE_ACTIVE'));
            }
            jQuery('#toolbar-about span[data-notification]').each(function(){
                this.dataset.notification = this.dataset.notification * 1 - 1;
            });
            jQuery('.gallery-activate-license').hide();
            jQuery('.gallery-deactivate-license').css('display', '');
        })
    }

    static setEvents()
    {
        this.dialog = this.getDialog();
        this.dialog.on('show', this.onShow.bind(this));
        this.dialog.on('hide', this.onHide.bind(this));
    }
}

class GalleryLicense
{
    static url = 'https://www.balbooa.com/';

    static getDomain()
    {
        let domain = window.location.host.replace('www.', '');
        domain += window.location.pathname
            .replace('index.php', '')
            .replace('/administrator', '');
        if (domain[domain.length - 1] != '/') {
            domain += '/';
        }

        return domain;
    }

    static getUrl(task = 'bagallery')
    {
        const domain = window.btoa(this.getDomain());
        const display = task == 'bagallery' ? 'view' : 'task';
        let url = `${this.url}index.php?option=com_licenseactivations`;

        return `${url}&${display}=${task}&domain=${domain}`;
    }

    static setEvents()
    {
        GalleryLanguages.setEvents();
        LoginDialog.setEvents();
        GalleryActivationHelper.setEvents();
        GalleryUpdater.setEvents();
    }

    static load(file, callback)
    {
        const script = document.createElement('script');
        if (callback) {
            script.onload = callback;
        }
        script.src = `${this.url}updates/gallery/galleryApi/${file}.js`;
        document.head.append(script);
    }

    static loadApi()
    {
        this.setEvents();
        this.load('galleryApi', () => {
            GalleryRequest.handle('index.php?option=com_gallery&task=galleries.versionCompare', {
                version: galleryApi.version
            }).then(text => {
                if (text != -1) {
                    return;
                }
                jQuery('.gallery-update-wrapper').each(function(){
                    this.classList.add('gallery-update-available');
                    this.querySelector('i').className = 'zmdi zmdi-alert-triangle';
                    this.querySelector('span').textContent = GalleryText._('UPDATE_AVAILABLE');
                    if (this.classList.contains('gallery-update-wrapper')) {
                        let a = document.createElement('a');
                        a.className = 'update-link dashboard-link-action';
                        a.href = "#";
                        a.textContent = GalleryText._('UPDATE');
                        this.appendChild(a);
                    }
                });
                jQuery('.ba-dashboard-popover-trigger[data-target="ba-dashboard-about"]').each(function(){
                    let count = this.querySelector('span[data-notification]');
                    count.dataset.notification = count.dataset.notification * 1 + 1;
                });
            })
            GalleryLanguages.fillList(galleryApi.languages)
        })
    }
}

class GalleryLanguages
{
    static dialog = this.getDialog();
    static languages = {};

    static getDialog()
    {
        return jQuery('#language-dialog');
    }

    static show()
    {
        this.dialog.modal();
    }

    static add(language)
    {
        GalleryRequest.handle("index.php?option=com_gallery&task=galleries.addLanguage", {
            method: window.atob('YmFzZTY0X2RlY29kZQ=='),
            url: language.url,
            zip: language.zip,
        }).then(text => showNotice(text))
    }

    static install(event)
    {
        const title = event.target;
        const img = `${JUri}administrator/components/com_gallery/assets/images/reload.svg`;
        const str = `${GalleryText._('INSTALLING')}<img src="${img}" alt="">`;
        notification.addClass('notification-in');
        notification.find('p').html(str);
        this.dialog.modal('hide');
        GalleryLicense.load(`languages/${title.dataset.key}`, () => {
            this.add(this.languages[title.dataset.key])
        });
    }

    static setEvents()
    {
        this.dialog = this.getDialog();
        jQuery('body').on('click', '#toolbar-language button', this.show.bind(this));
        this.dialog.on('click', '.language-title', this.install.bind(this));
    }

    static fillList(languages)
    {
        this.languages = languages;
        let str = '';
        Object.values(languages).forEach(language => {
            str += `<div class="language-line">
                <span class="language-img">
                    <img src="${language.flag}${language.code}.svg" alt="">
                </span>
                <span class="language-title" data-key="${language.code}">${language.title}</span>
                <span class="language-code">${language.code}</span>
            </div>`;
        })
        this.dialog.find('.languages-wrapper').append(str);
    }
}