<?php
/**
* @package   Gallery
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gallery\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gallery\Administrator\Helper\Filesystem\File;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;

class DisplayController extends BaseController
{
    protected $default_view = 'galleries';

    public function display($cachable = false, $urlparams = false) 
    {
        $develop = $this->input->get('develop', '', 'string');
        if ($develop == 'refreshDB') {
            $this->refreshDB();
        }
        parent::display($cachable, $urlparams);
    }

    static function refreshDB():void
    {
        $path = JPATH_COMPONENT . '/installation/test.sql';
        $str = File::read($path);
        $db = Factory::getDbo();
        $queries = $db->splitSql($str);
        foreach ($queries as $query) {
            $db->setQuery($query)
                ->execute();
        }

        dd('Database Refreshed');
    }
}