<?php
/**
* @package   Gallery
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gallery\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gallery\Administrator\Helper\ExtensionInfo;
use Balbooa\Component\Gallery\Administrator\Helper\Filesystem\File;
use Balbooa\Component\Gallery\Administrator\Helper\Filesystem\Folder;
use Balbooa\Component\Gallery\Administrator\Helper\GalleryDesignHelper;
use Balbooa\Component\Gallery\Administrator\Helper\GalleryHelper;
use Balbooa\Component\Gallery\Administrator\Helper\GalleryXmlHelper;
use Balbooa\Component\Gallery\Administrator\Model\GalleryModel;
use Joomla\Archive\Archive;
use Joomla\CMS\Factory;
use Joomla\CMS\Installer\Installer;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Response\JsonResponse;

class GalleriesController extends AdminController
{
    protected $option = 'com_gallery';

    public function getModel($name = 'Gallery', $prefix = 'Administrator', $config = ['ignore_request' => true])
	{
        $model = parent::getModel($name, $prefix, $config);

        return $model;
	}

    public function versionCompare():void
    {
        $about = ExtensionInfo::get();
        $version = $this->input->get('version', '', 'string');
        $compare = version_compare($about->version, $version);
        echo $compare;
        exit();
    }

    public function cleanup()
    {
        GalleryHelper::cleanup();
        echo Text::_('COM_GALLERY_N_ITEMS_DELETED');
        exit;
    }

    public function getCategories() :void
    {
        $id = $this->input->get('id', 0, 'int');
        /** @var GalleryModel $model */
        $model = $this->getModel();
        $categories = $model->getCategories($id);
        $result = [];
        foreach ($categories as $category) {
            if ($category->category_all == 1) {
                continue;
            }
            $result[] = $category;
        }
        print_r(json_encode($result));
        exit;
    }

    public function duplicate()
    {
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        /** @var GalleryModel $model */
        $model = $this->getModel();
        $model->duplicate($pks);
        $this->setMessage(Text::plural('GALLERY_DUPLICATED', count($pks)));
        $this->setRedirect('index.php?option=com_gallery&view=galleries');
    }

    public function getDesign(): never
    {
        $id = $this->input->get('id', 0, 'int');
        $design = (new GalleryDesignHelper())->get($id);
        $str = json_encode($design);
        echo $str;exit;
    }

    public function pasteDesign(): never
    {
        $id = $this->input->get('id', 0, 'int');
        $str = $this->input->get('design', '{}', 'raw');
        $design = json_decode($str);
        (new GalleryDesignHelper())->paste($id, $design);
        echo Text::_('SETTINGS_PASTED_SUCCESSFULLY');
        exit;
    }

    public function download(): never
    {
        $file = $this->input->get('file', '', 'string');
        (new GalleryXmlHelper())->download($file);
        exit();
    }

    public function import(): never
    {
        $file = $this->input->files->get('file', '', 'array');
        (new GalleryXmlHelper())->import($file);
        exit();
    }

    public function export(): never
    {
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $file = (new GalleryXmlHelper())->export($pks);
        echo new JsonResponse(true, $file);
        exit();
    }

    public function updateGallery()
    {
        $config = Factory::getConfig();
        $path = $config->get('tmp_path') . '/pkg_Gallery.zip';
        $data = file_get_contents('php://input');
        $obj = json_decode($data);
        $method = $obj->method;
        $data = $method($obj->package);
        $file = fopen($path, "w+");
        fputs($file, $data);
        fclose($file);
        $this->extract($path, $config->get('tmp_path') . '/pkg_Gallery');
        $installer = Installer::getInstance();
        $installer->update($config->get('tmp_path') . '/pkg_Gallery');
        File::delete($path);
        Folder::delete($config->get('tmp_path') . '/pkg_Gallery');
        exit;
    }

    public function extract($from, $to): void
    {
        $archive = new Archive();
        $archive->extract($from, $to);
    }

    public function checkGalleryState(): void
    {
        $state = GalleryHelper::checkGalleryState();
        print_r($state);exit();
    }

    public function getUserLicense()
    {
        $input = Factory::getApplication()->input;
        $data = $input->get('data', '', 'string');
        GalleryHelper::setAppLicense($data);
    }

    public function addLanguage()
    {
        $input = Factory::getApplication()->input;
        $method = $input->get('method', '', 'string');
        $url = $input->get('url', '', 'string');
        $zip = $input->get('zip', '', 'string');
        $name = explode('/', $url);
        $name = end($name);
        $config = Factory::getConfig();
        $tmp_path = $config->get('tmp_path');
        $path = $tmp_path . '/'. $name;
        $name = explode('.', $name);
        $data = $method($zip);
        $file = fopen($path, "w+");
        fputs($file, $data);
        fclose($file);
        $this->extract($path, $tmp_path . '/' .$name[0]);
        $installer = Installer::getInstance();
        $installer->install($tmp_path . '/'. $name[0]);
        File::delete($path);
        Folder::delete($tmp_path . '/' . $name[0]);
        echo Text::_('SUCCESS_INSTALL');
        exit;
    }
}