<?php
/**
 * @package   Gallery
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Gallery\Administrator\Helper;

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

abstract class ExtensionInfo
{
    protected static string $extension = 'com_gallery';
    protected static string $xmlPath = '/administrator/components/com_gallery/gallery.xml';

    public static function get(): object
    {
        $about = static::getManifestData();
        $about->tag = static::getXmlTag();

        return $about;
    }

    protected static function getManifestData(): object
    {
        $db = Factory::getDbo();

        $query = $db->getQuery(true)
            ->select('manifest_cache')
            ->from('#__extensions')
            ->where('type = ' . $db->quote('component'))
            ->where('element = ' . $db->quote(self::$extension));

        $db->setQuery($query);

        $manifestCache = $db->loadResult();

        return json_decode($manifestCache);
    }

    protected static function getXmlTag(): string
    {
        $xml = simplexml_load_file(JPATH_ROOT . self::$xmlPath);

        return (string) $xml->tag;
    }
}