<?php
/**
 * @package   Gallery
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Gallery\Administrator\Helper;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;

defined('_JEXEC') or die;

class GalleryDesignHelper
{
    protected DatabaseInterface $db;
    protected array $exceptions = [
        'id', 'title', 'published'
    ];

    public function __construct()
    {
        $this->db = Factory::getContainer()->get(DatabaseInterface::class);
    }

    protected function clearExceptions(object &$object): void
    {
        foreach ($this->exceptions as $exception) {
            unset($object->$exception);
        }
    }

    protected function load(int $id)
    {
        $query = $this->db->getQuery(true)
            ->select('*')
            ->from('#__gallery_galleries')
            ->where('id = ' . $id);
        $this->db->setQuery($query);

        return $this->db->loadObject();
    }

    public function get(int $id): object
    {
        $design = $this->load($id);
        $this->clearExceptions($design);

        return $design;
    }

    public function paste(int $id, object $design): void
    {
        $gallery = $this->load($id);
        foreach ($design as $name => $value) {
            $gallery->$name = $value;
        }
        $this->db->updateObject('#__gallery_galleries', $gallery, 'id');
    }
}