<?php
/**
* @package   Gallery
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gallery\Administrator\Helper;

use Balbooa\Component\Gallery\Administrator\Helper\Filesystem\File;
use Balbooa\Component\Gallery\Administrator\Helper\Filesystem\Folder;
use Balbooa\Component\Gallery\Administrator\Helper\Image\Processor;
use Balbooa\Component\Gallery\Site\Trait\CompatibilityTrait;
use Balbooa\Component\Gallery\Site\Trait\ParamsTrait;
use Joomla\CMS\Factory;
use Joomla\CMS\Filter\OutputFilter;
use Joomla\CMS\Language\Text;
use Joomla\Database\DatabaseInterface;

defined('_JEXEC') or die;

if (!function_exists('mb_strtolower')) {
    function mb_strtolower($str, $encoding = 'utf-8'): string
    {
        return strtolower($str);
    }
}

abstract class GalleryHelper 
{
    use CompatibilityTrait;
    use ParamsTrait;
    
    public static function replaceLongPath(string $path): string
    {
        $image_path = self::$params->image_path;
        $pos = strpos($path, '/'.$image_path.'/');
        $pos1 = strpos($path, $image_path.'/');
        if ($pos != 0 && $pos1 != 0) {
            $path = substr($path, $pos);
        }

        return $path;
    }

    public static function checkFileName(string $dir, string $name): string
    {
        $file = $dir . $name;
        if (File::exists($file)) {
            $name = rand(0, 10).'-'.$name;
            $name = self::checkFileName($dir, $name);
        }

        return $name;
    }

    public static function makeSafe(string $file): string
    {
        $file = rtrim($file, '.');
        if (function_exists('transliterator_transliterate') && function_exists('iconv')) {
            $file = iconv("UTF-8", "ASCII//TRANSLIT//IGNORE", transliterator_transliterate('Any-Latin; Latin-ASCII; Lower()', $file));
        }
        $regex = array('#(\.){2,}#', '#[^A-Za-z0-9\.\_\- ]#', '#^\.#');

        return trim(preg_replace($regex, '', $file));
    }

    public static function canCompress(string $ext): bool
    {
        return self::$params->compress_images == 1 && in_array($ext, self::$params->compress_ext);
    }

    public static function compressImage($source, $dir, $file, $ext, $isString = true)
    {
        $endExt = $ext;
        $gd_info = gd_info();
        if (self::$params->compress_to_webp == 1 && $gd_info['WebP Support']) {
            $name = basename($file);
            $name = File::stripExt($name);
            $file = str_replace($name.'.'.$ext, $name.'.webp', $file);
            $file = self::checkFileName($dir, $file);
            $endExt = 'webp';
        }
        $path = $dir.$file;
        $imageSave = Processor::getSaveFunction($endExt);
        $tempPath = JPATH_ROOT . '/tmp/' . $file;
        if ($isString) {
            $img = imagecreatefromstring($source);
            file_put_contents($tempPath, $source);
        } else {
            $imageCreate = Processor::getCreateFunction($ext);
            $img = $imageCreate($source);
            File::upload($source, $tempPath);
        }
        $img = Processor::correctOrientation($file, $img, $ext);
        unlink($tempPath);
        $width = imagesx($img);
        $height = imagesy($img);
        $size = self::$params->compress_size;
        $quality = min(self::$params->compress_quality, 100);
        if ($width <= $size && $height <= $size) {
            $w = $width;
            $h = $height;
        } else {
            $ratio = $width / $height;
            if ($width > $height) {
                $w = $size;
                $h = $size / $ratio;
            } else {
                $h = $size;
                $w = $size * $ratio;
            }
        }
        $out = imagecreatetruecolor($w, $h);
        if ($ext == 'png' || $ext == 'webp') {
            imagealphablending($out, false);
            imagesavealpha($out, true);
            $transparent = imagecolorallocatealpha($out, 255, 255, 255, 127);
            imagefilledrectangle($out, 0, 0, $w, $h, $transparent);
        }
        imagecopyresampled($out, $img, 0, 0, 0, 0, $w, $h, $width, $height);
        if ($endExt == 'png') {
            $quality = 9 - round($quality / 11.111111111111);
        }
        $imageSave($out, $path, $quality);
        imagedestroy($out);
        imagedestroy($img);

        return $file;
    }
    
    public static function cleanup()
    {
        $dir = self::$thumbnails_base.'/bagallery/original/';
        $db = Factory::getContainer()->get(DatabaseInterface::class);
        if (!Folder::exists($dir)) {
            return;
        }
        $images = Folder::files($dir);
        foreach ($images as $image) {
            $name = '%bagallery/original/'.$image;
            $name1 = '%bagallery/original//'.$image;
            $query = $db->getQuery(true);
            $query->select('COUNT(id)')
                ->from('`#__gallery_items`')
                ->where('`path` like '.$db->quote($name).' OR `path` like '.$db->quote($name1));
            $db->setQuery($query);
            $count = $db->loadResult();
            if ($count !== 0) {
                continue;
            }

            $where = 'settings like ' . $db->quote($name) . ' OR settings like '
                . $db->quote($name1) . ' OR image like ' . $db->quote($name)
                . ' OR  image like ' . $db->quote($name1);
            $query = $db->getQuery(true)
                ->select('COUNT(id)')
                ->from('`#__gallery_category`')
                ->where($where);
            $db->setQuery($query);
            $count = $db->loadResult();
            if ($count == 0) {
                File::delete($dir.$image);
            }
        }
    }

    public static function getGalleryLanguage() :string
    {
        $result = array();
        $path = JPATH_ROOT.'/administrator/components/com_gallery/language/en-GB/en-GB.com_gallery.ini';
        if (File::exists($path)) {
            $handle = fopen($path, "r");
            $contents = fread($handle, filesize($path));
            $contents = str_replace('_QQ_', '"\""', $contents);
            $data = parse_ini_string($contents);
            foreach ($data as $ind => $value) {
                $result[$ind] = Text::_($ind);
            }
        }
        $data = 'var galleryLanguage = '.json_encode($result).';';

        return $data;
    }

    public static function getJoomlaCheckboxes($name, $form): string
    {
        $input = $form->getField($name);
        $value = $form->getValue($name);
        if ($value === null) {
            $value = $form->getFieldAttribute($name, 'default');
        }
        $class = !empty($input->class) ? ' class="' . $input->class . '"' : '';
        $checked = $input->checked || $value == 1 ? ' checked' : '';
        
        return '<input type="checkbox" name="'.$input->name.'" id="'.$input->id.'" value="1"'.$class.$checked.'>';
    }

    public static function getAccess(): array
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id, title')
            ->from('#__viewlevels')
            ->order($db->quoteName('ordering') . ' ASC')
            ->order($db->quoteName('title') . ' ASC');
        $db->setQuery($query);
        $array = $db->loadObjectList();
        $access = [];
        foreach ($array as $value) {
            $access[$value->id] = $value->title;
        }

        return $access;
    }

    public static function checkGalleryState()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('`key`')
            ->from('#__gallery_api')
            ->where('service = '.$db->quote('balbooa'));
        $db->setQuery($query);
        $balbooa = $db->loadResult();
        if (empty($balbooa)) {
            $obj = new \stdClass();
            $obj->key = '{}';
            $obj->service = 'balbooa';
            $db->insertObject('#__gallery_api', $obj);
            $balbooa = $obj->key;
            $obj = new \stdClass();
            $obj->key = '{}';
            $obj->service = 'balbooa_activation';
            $db->insertObject('#__gallery_api', $obj);
        }

        return $balbooa;
    }

    public static function checkGalleryActivation()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('`key`')
            ->from('#__gallery_api')
            ->where('service = '.$db->quote('balbooa_activation'));
        $db->setQuery($query);

        return $db->loadResult();
    }

    public static function setAppLicense($data)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gallery_api')
            ->where('service = '.$db->quote('balbooa'));
        $db->setQuery($query);
        $balbooa = $db->loadObject();
        $balbooa->key = json_decode($balbooa->key);
        $balbooa->key->data = $data;
        $balbooa->key = json_encode($balbooa->key);
        $db->updateObject('#__gallery_api', $balbooa, 'id');
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gallery_api')
            ->where('service = '.$db->quote('balbooa_activation'));
        $db->setQuery($query);
        $balbooa = $db->loadObject();
        $balbooa->key = '{"data":"active"}';
        $db->updateObject('#__gallery_api', $balbooa, 'id');
    }

    public static function replaceFilename($str)
    {
        $str = str_replace([
            '?', '!', '.', ',', ':', ';', '*', '(', ')', '{', '}',
            '***91;', '&', '<', '>', '***93;', '%', '#', '№', '@', '$',
            '^', '-', '+', '/', '\\', '=','|', '"', '\''
        ], ' ', $str);
        $str = preg_replace('/\s+/', ' ', $str);
        $str = str_replace(['а', 'б', 'в', 'г', 'д', 'е', 'ё', 'з', 'и', 'й',
            'к', 'л', 'м', 'н', 'о', 'п', 'р', 'с', 'т', 'у', 'ф', 'х', 'ъ',
            'ы', 'э', ' ', 'ж', 'ц', 'ч', 'ш', 'щ', 'ь', 'ю', 'я', 'А', 'Б',
            'В', 'Г', 'Д', 'Е', 'Ё', 'З', 'И', 'Й',
            'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Ч', 'Ъ',
            'Ы', 'Э', 'Ж', 'Ц', 'Ч', 'Ш', 'Щ', 'Ь', 'Ю', 'Я'
        ], [
            'a', 'b', 'v', 'g', 'd', 'e', 'e', 'z', 'i', 'y', 'k', 'l',
            'm', 'n', 'o', 'p', 'r', 's', 't', 'u', 'f', 'h', 'j', 'i', 'e',
            '-', 'zh', 'ts', 'ch', 'sh', 'shch', '', 'yu', 'ya', 'A', 'B', 'V',
            'G', 'D', 'E', 'E', 'Z', 'I', 'Y', 'K', 'L', 'M', 'N',
            'O', 'P', 'R', 'S', 'T', 'U', 'F', 'H', 'J', 'I', 'E', 'Zh', 'Ts',
            'Ch', 'Sh', 'Shch', '', 'Yu', 'Ya'
        ], $str);
        $str = trim($str);

        return preg_replace("/_{2,}/", "-", $str);
    }

    public static function replace($str)
    {
        $str = mb_strtolower($str, 'utf-8');
        $search = array('?', '!', '.', ',', ':', ';', '*', '(', ')', '{', '}', '***91;',
            '***93;', '%', '#', '№', '@', '$', '^', '-', '+', '/', '\\', '=',
            '|', '"', '\'', 'а', 'б', 'в', 'г', 'д', 'е', 'ё', 'з', 'и', 'й',
            'к', 'л', 'м', 'н', 'о', 'п', 'р', 'с', 'т', 'у', 'ф', 'х', 'ъ',
            'ы', 'э', ' ', 'ж', 'ц', 'ч', 'ш', 'щ', 'ь', 'ю', 'я');
        $replace = array('-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-',
            '-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-',
            'a', 'b', 'v', 'g', 'd', 'e', 'e', 'z', 'i', 'y', 'k', 'l', 'm', 'n',
            'o', 'p', 'r', 's', 't', 'u', 'f', 'h', 'j', 'i', 'e', '-', 'zh', 'ts',
            'ch', 'sh', 'shch', '', 'yu', 'ya');
        $str = str_replace($search, $replace, $str);
        $str = trim($str);
        $str = preg_replace("/_{2,}/", "-", $str);

        return $str;
    }

    public static function increment($string)
    {
        if (preg_match('#\((\d+)\)$#', $string, $matches)) {
            $n = $matches[1] + 1;
            $string = preg_replace('#\(\d+\)$#', sprintf('(%d)', $n), $string);
        } else {
            $n = 2;
            $string .= sprintf(' (%d)', $n);
        }

        return $string;
    }

    public static function getAlias($alias, $table, $name = 'lightboxUrl', $id = 0)
    {
        $alias = self::replace($alias);
        $alias = OutputFilter::stringURLSafe($alias);
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id')
            ->from($table)
            ->where($db->quoteName($name).' = '.$db->Quote($alias))
            ->where('`id` <> ' .$db->Quote($id));
        $db->setQuery($query);
        $id = $db->loadResult();
        if (!empty($id)) {
            $alias = self::increment($alias);
            $alias = self::getAlias($alias, $table, $name);
        }
        return $alias;
    }
}

GalleryHelper::prepareParams();