<?php
/**
 * @package     Joomla.Libraries
 * @subpackage  HTML
 *
 * @copyright   Copyright (C) 2005 - 2016 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

namespace Balbooa\Component\Gallery\Administrator\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Date\Date;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Utilities\ArrayHelper;

abstract class HtmlStatesHelper
{
    protected static array $states = [
        [
            'task' => 'publish',
            'title' => 'JUNPUBLISHED'
        ],
        [
            'task' => 'unpublish',
            'title' => 'JPUBLISHED'
        ]
    ];

    public static function disabled(): string
    {
        return <<<HTML
            <a class="disabled" href="javascript:void(0);">
                <i class="zmdi zmdi-eye ba-icon-md"></i>
            </a>
        HTML;
    }

    public static function published(
        int $value,
        int $i,
        string $prefix = '',
        bool $enabled = true
    ): string {
        if (!$enabled) {
            return self::disabled();
        }

        $state = self::$states[$value];
        $task = $prefix . $state['task'];
        $text = Text::_($state['title']);
        $icon = $state['task'] != 'publish' ? 'zmdi zmdi-eye' : 'zmdi zmdi-eye-off';

        return <<<HTML
            <a href="javascript:void(0);"
                onclick="return Joomla.listItemTask('cb$i', '$task');">
                <i class="$icon ba-icon-md"></i>
                <span class="ba-tooltip ba-hide-element ba-top">$text</span>
            </a>
        HTML;
    }
}