<?php
/**
 * @package   Gallery
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Gallery\Administrator\Helper\Image;

use Balbooa\Component\Gallery\Administrator\Helper\Filesystem\File;
use Exception;
use GdImage;

defined('_JEXEC') or die;

abstract class Processor
{
    protected static function getType(string $ext): Type
    {
        return Type::fromExtension($ext) ?? Type::JPG;
    }

    public static function isSupportedExtension(string $ext): bool
    {
        return Type::fromExtension($ext) !== null;
    }

    public static function getCreateFunction(string $ext): string
    {
        return self::getType($ext)
            ->createFunction();
    }

    public static function getSaveFunction(string $ext): string
    {
        return self::getType($ext)
            ->saveFunction();
    }

    public static function correctOrientation(string $filePath, GdImage $image, string $ext): GdImage
    {
        if (!self::supportsExif($ext)) {
            return $image;
        }

        $exif = @exif_read_data($filePath);
        if (!empty($exif['Orientation'])) {
            $image = self::applyExifOrientation($image, $exif['Orientation']);
        }

        return $image;
    }

    private static function supportsExif(string $ext): bool
    {
        return self::getType($ext)
            ->haveExif();
    }


    private static function applyExifOrientation(GdImage $image, int $orientation): GdImage
    {
        return match ($orientation) {
            3 => imagerotate($image, 180, 0),
            6 => imagerotate($image, -90, 0),
            8 => imagerotate($image, 90, 0),
            default => $image
        };
    }
}