<?php
/**
 * @package   Gallery
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Component\Gallery\Administrator\Helper\Image;

defined('_JEXEC') or die;

enum Type: string
{
    case JPG  = 'jpg';
    case JPEG = 'jpeg';
    case PNG  = 'png';
    case GIF  = 'gif';
    case WEBP = 'webp';

    public function createFunction(): string
    {
        return match ($this) {
            self::PNG => 'imagecreatefrompng',
            self::GIF => 'imagecreatefromgif',
            self::WEBP => 'imagecreatefromwebp',
            default => 'imagecreatefromjpeg',
        };
    }

    public function saveFunction(): string
    {
        return match ($this) {
            self::PNG => 'imagepng',
            self::GIF => 'imagegif',
            self::WEBP => 'imagewebp',
            default => 'imagejpeg',
        };
    }

    public function haveExif(): bool
    {
        return function_exists('exif_read_data') && match ($this) {
            self::JPEG, self::JPG => true,
            default => false,
        };
    }

    public static function fromExtension(string $ext): ?self
    {
        return self::tryFrom(strtolower($ext));
    }
}