<?php
/**
* @package   Gallery
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gallery\Administrator\View\Galleries;

use Balbooa\Component\Gallery\Administrator\Helper\ExtensionInfo;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseView;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\WebAsset\WebAssetManager;

defined('_JEXEC') or die;

class HtmlView extends BaseView
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $about;
    protected $count;
    protected WebAssetManager $wa;
    
    public function display($tpl = null) 
    {
        $this->initializeView();
        $this->addToolBar();
        $this->registerAssets();

        parent::display($tpl);
    }

    protected function initializeView(): void
    {
        $this->wa = $this->getDocument()->getWebAssetManager();
        $this->about = ExtensionInfo::get();
        $this->items = $this->get('Items');
        $this->count = $this->get('count');
        $this->pagination = $this->get('Pagination');
        $this->state = $this->get('State');
    }

    protected function registerAssets(): void
    {
        $doc = $this->getDocument();
        $this->wa->useScript('list-view');
        $this->wa->registerAndUseStyle('com_gallery.admin.css', 'components/com_gallery/assets/css/ba-admin.css?'.$this->about->version);
        if ($doc->getDirection() == 'rtl') {
            $this->wa->registerAndUseStyle('com_gallery.admin.rtl', 'components/com_gallery/assets/css/rtl-ba-admin.css?'.$this->about->version);
        }
        if (JVERSION >= '4.0.0') {
            $this->wa->registerAndUseScript('com_gallery.jquery', Uri::root().'/media/vendor/jquery/js/jquery.min.js');
        }
        if ($this->_layout != 'modal') {
            $this->wa->registerAndUseScript('com_gallery.about', 'components/com_gallery/assets/js/ba-about.js?'.$this->about->version);
            $this->wa->registerAndUseScript('com_gallery.bootstrap', Uri::root().'components/com_gallery/assets/js/bootstrap.js?'.$this->about->version);
        }
    }
    
    protected function addToolBar(): void
    {
        $toolbar = Toolbar::getInstance();
        ToolbarHelper::title(Text::_('GALLERIES_TITLE'), 'image');
        $user = $this->getCurrentUser();
        if ($user->authorise('core.duplicate', 'com_gallery')) {
            $toolbar->standardButton('copy', 'JTOOLBAR_DUPLICATE', 'galleries.duplicate')
                ->listCheck(true);
        }
        if ($user->authorise('core.edit.state', 'com_gallery')) {
            $toolbar->publish('galleries.publish')->listCheck(true);
            $toolbar->unpublish('galleries.unpublish')->listCheck(true);
        }
        if ($user->authorise('core.delete', 'com_gallery')) {
            if ($this->state->get('filter.state') == -2) {
                $toolbar->delete('galleries.delete')->listCheck(true);
            } else {
                $toolbar->trash('galleries.trash')->listCheck(true);
            }
        }
        $dropdown = $toolbar->dropdownButton('status-group')
            ->text('MORE_ACTIONS')
            ->toggleSplit(false)
            ->buttonClass('btn btn-action');
        $childBar = $dropdown->getChildToolbar();
        $childBar->standardButton('download', 'EXPORT', 'galleries.export')
            ->listCheck(true);
        $childBar->standardButton('upload', 'IMPORT', 'galleries.import');
        if ($user->authorise('core.admin', 'com_gallery') || $user->authorise('core.options', 'com_gallery')) {
            $toolbar->preferences('com_gallery');
        }
    }
    
    protected function getSortFields(): array
    {
        return [
            'published' => Text::_('JSTATUS'),
            'title' => Text::_('JGLOBAL_TITLE'),
            'id' => Text::_('JGRID_HEADING_ID')
        ];
    }
}