<?php
/**
* @package   Gallery
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Plugin\EditorsXtd\Gallery\Extension;

use Balbooa\Component\Gallery\Administrator\Helper\Filesystem\File;
use Joomla\CMS\Factory;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Plugin\CMSPlugin;
use Balbooa\Component\Gallery\Administrator\Helper\GalleryHelper;

defined('_JEXEC') or die;


class Gallery extends CMSPlugin
{
    public function __construct($subject, $config)
    {
        parent::__construct($subject, $config);
    }

    public function onDisplay($name)
    {
        $js = File::read(JPATH_ROOT . '/plugins/editors-xtd/gallery/assets/js/script.js');
        $icon = File::read(JPATH_ROOT . '/plugins/editors-xtd/gallery/assets/images/icon.svg');
        $js = str_replace('$name', $name, $js);
        $doc = Factory::getDocument();
        $doc->addScriptDeclaration($js);
        $link = 'index.php?option=com_gallery&amp;view=galleries&amp;layout=modal&amp;tmpl=component';
        $button = new CMSObject();
        $button->modal = true;
        $button->class = 'btn';
        $button->link = $link;
        $button->text = 'Gallery';
        $button->name = 'picture';
        $button->options = "{handler: 'iframe', size: {x: 740, y: 545}}";
        $button->icon = 'picture';
        $button->iconSVG = $icon;

        return $button;
    }
}
