<?php
/**
 * @package   Gallery
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

namespace Balbooa\Plugin\System\Gallery\Extension;

defined('_JEXEC') or die;

use Balbooa\Component\Gallery\Administrator\Helper\ExtensionInfo;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Balbooa\Component\Gallery\Site\Helper\GalleryHelper;
use Joomla\CMS\Installer\Installer;
use Joomla\CMS\Http\HttpFactory;

class Gallery extends CMSPlugin
{
    public function __construct($subject, $config)
    {
        parent::__construct($subject, $config);
    }

    public function onAfterInitialise()
    {
        $app = Factory::getApplication();
        if ($app->isClient('site')) {
            $params = ComponentHelper::getParams('com_gallery');
            GalleryHelper::prepareParams($params);
            if (isset($_GET['fbclid'])) {
                $url = $_SERVER['REQUEST_URI'];
                $pos = strpos($url, 'fbclid');
                $delimiter = $url[$pos - 1];
                $url = str_replace($delimiter.'fbclid='.$_GET['fbclid'], '', $url);
                header('Location: '.$url);exit;
            }
        }
    }

    public function onBeforeCompileHead()
    {
        $app = Factory::getApplication();
        $doc = Factory::getDocument();
        $option = $app->input->get('option', '', 'string');
        $a_id = $app->input->get('a_id', '', 'string');
        if ($app->isClient('site') && empty($a_id) && $doc->getType() == 'html'
            && $option != 'com_config') {
            GalleryHelper::addStyle();
        }
    }

    public function onAfterRender()
    {
        $app = Factory::getApplication();
        $doc = Factory::getDocument();
        if ($app->isClient('site') && $doc->getType() == 'html') {
            $this->setGalleries();
        } else if ($doc->getType() == 'html') {
            $this->uninstallBagallery();
        }
    }

    public function onInstallerBeforePackageDownload(&$url, &$headers)
    {
        if (!str_contains($url, 'com_licenseactivations&task=bagallery.update')) {
            return;
        }
        $about = ExtensionInfo::get();
        $url .= '&amp;tag=' . $about->tag;
        if ($about->tag == 'free') {
            return;
        }
        $state = GalleryHelper::checkGalleryActivation('balbooa');
        $url .= '&amp;data=' . ($state->data ?? '');
        $language = Factory::getApplication()->getLanguage();
        $language->load('com_gallery', JPATH_ADMINISTRATOR);
        if (isset($state->data)) {
            $this->checkUpdateLicense($state);

            return;
        }
        $this->setUpdateError(Text::_('ACTIVATE_LICENSE_BEFORE_UPDATE'));
    }

    private function setUpdateError($message)
    {
        $app = Factory::getApplication();
        $app->enqueueMessage($message, 'error');
        $app->redirect('index.php?option=com_installer&view=update');
    }

    private function checkUpdateLicense($state)
    {
        $uri = 'https://www.balbooa.com/index.php?option=com_licenseactivations'
            . '&amp;task=bagallery.checkUpdateLicense&amp;data=' . $state->data;
        $response = HttpFactory::getHttp()->get($uri);
        $object = json_decode($response->body);
        if (!$object->flag) {
            $this->setUpdateError(Text::_('RENEW_LICENSE_BEFORE_UPDATE'));
        }
    }

    private function checkBagallery($element = 'com_bagallery')
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('extension_id')
            ->from("#__extensions")
            ->where('element = ' . $db->quote($element));
        $db->setQuery($query);
        $extension_id = $db->loadResult();

        return $extension_id;
    }

    private function uninstallBagallery()
    {
        $extension_id = $this->checkBagallery();
        if (empty($extension_id)) {
            return;
        }
        $type = 'component';
        $installer = Installer::getInstance();
        $pkg_id = $this->checkBagallery('pkg_BaGallery');
        if ($pkg_id) {
            $extension_id = $pkg_id;
            $type = 'package';
        }
        $file = JPATH_ROOT . '/administrator/components/com_bagallery/script.php';
        if (file_exists($file)) {
            file_put_contents($file, "<?php class com_bagalleryInstallerScript {}");
        }
        $installer->uninstall($type, $extension_id);
        $app = Factory::getApplication();
        $app->redirect('index.php?option=com_installer&view=install');
    }

    public function onBeforeRenderGridbox()
    {
        $this->setGalleries();
    }

    public function setGalleries()
    {
        /**
         * @var Joomla\CMS\Application\SiteApplication
         */
        $app = Factory::getApplication();
        $option = $app->input->get('option', '', 'string');
        $a_id = $app->input->get('a_id', '', 'string');
        if (empty($a_id) && $option != 'com_config' && $option != 'com_search'
            && $option != 'com_finder') {
            $view = $app->input->get('view', '', 'string');
            if (!($option == 'com_sppagebuilder' && $view == 'form')) {
                $html = $app->getBody();
                $pos = strpos($html, '</head>');
                $head = substr($html, 0, $pos);
                $body = substr($html, $pos);
                if (strpos($head, 'name="og:') !== false) {
                    $head = str_replace('name="og:', 'property="og:', $head);
                    if (strpos($head, 'prefix="og: http://ogp.me/ns#"') === false) {
                        $head = str_replace('<html', '<html prefix="og: http://ogp.me/ns#" ', $head);
                    }
                }
                $html = $head . GalleryHelper::renderGalleryHTML($body);
                $app->setBody($html);
            }
        } else if ($option == 'com_search' || $option == 'com_finder') {
            $regex = '/\[gallery ID=+(.*?)\]/i';
            $html = $app->getBody();
            preg_match_all($regex, $html, $matches, PREG_SET_ORDER);
            if ($matches) {
                $html = @preg_replace($regex, '', $html);
                $app->setBody($html);
            }
        }
    }
}

function gallery_sc(){}