<?php
/**
 * @package   Gallery
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Cache\Cache;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseInterface;

class pkg_galleryInstallerScript
{
    protected string $updates = '/administrator/components/com_gallery/installation/updates/mysql/';

    public function install($parent)
    {
        $this->disablePlugins('system');
        $this->enablePlugins('editors-xtd');
        $this->enablePlugins('system');
        $this->deleteScript();
        $this->extendParams();
    }

    public function uninstall($parent){}

    public function update($parent){}

    public function preflight($type, $parent)
    {
        if (JVERSION < '4.0.0') {
            $msg = 'Your Joomla version is outdated and incompatible with' .
                ' this extension. Update Joomla!';
            JError::raiseWarning(null, $msg);
            return false;
        }
        $this->renameTables();
    }

    protected function migrateUpdates(): void
    {
        $dir = JPATH_ROOT . $this->updates;
        if (!is_dir($dir)) {
            return;
        }
        $files = scandir($dir);
        foreach ($files as $file) {
            if ($file == "." || $file == ".." || !str_contains($file, '.sql')) {
                continue;
            }
            $version = str_replace('.sql', '', $file);
            if (version_compare($version, '2.3.0') > 0) {
                $this->executeUpdate($dir . $file);
            }
        }
    }

    protected function executeUpdate(string $path): void
    {
        $handle = fopen($path, "r");
        $str = fread($handle, filesize($path));
        fclose($handle);
        $db = Factory::getContainer()->get(DatabaseInterface::class);
        $queries = $db->splitSql($str);
        try {
            foreach ($queries as $query) {
                $db->setQuery($query)
                    ->execute();
            }
        } catch (\Exception $e) {

        }
    }

    public function postflight($type, $parent)
    {
        $this->migrateUpdates();
        $this->clearCache();
    }

    private function deleteScript()
    {
        $file = JPATH_ROOT . '/administrator/components/com_bagallery/script.php';
        if (file_exists($file)) {
            file_put_contents($file, "<?php\ndefined('_JEXEC') or die;\nclass com_bagalleryInstallerScript{}");
        }
    }

    private function checkBagallery($element = 'com_bagallery')
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('extension_id')
            ->from("#__extensions")
            ->where('element = ' . $db->quote($element));
        $db->setQuery($query);
        $extension_id = $db->loadResult();

        return $extension_id;
    }

    private function extendParams():void
    {
        $extension_id = $this->checkBagallery();
        if (empty($extension_id)) {
            return;
        }
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('params')
            ->from("#__extensions")
            ->where('element = ' . $db->quote('com_bagallery'));
        $db->setQuery($query);
        $params = $db->loadResult();
        $query = $db->getQuery(true)
            ->update("#__extensions")
            ->set('params = ' . $db->quote($params))
            ->where('element = ' . $db->quote('com_gallery'));
        $db->setQuery($query)
            ->execute();
        $this->extendAssets();
    }

    private function extendAssets():void
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('rules')
            ->from('#__assets')
            ->where('name = ' . $db->quote('com_bagallery'));
        $db->setQuery($query);
        $rules = $db->loadResult();
        if (empty($rules)) {
            return;
        }
        /** @var \Joomla\CMS\Table\Asset $asset */
        $asset = Table::getInstance('Asset');
        $asset->loadByName('com_gallery');
        $asset->name      = 'com_gallery';
        $asset->parent_id = 1;
        $asset->rules     = '{}';
        $asset->title     = 'Gallery';
        $asset->setLocation(1, 'last-child');
    }

    private function renameTables()
    {
        $result = $this->checkBagallery();
        if (empty($result)) {
            return;
        }
        $db = Factory::getDbo();
        $array = [
            'RENAME TABLE `#__bagallery_galleries` TO `#__gallery_galleries`',
            'RENAME TABLE `#__bagallery_category` TO `#__gallery_category`',
            'RENAME TABLE `#__bagallery_items` TO `#__gallery_items`',
            'RENAME TABLE `#__bagallery_users` TO `#__gallery_users`',
            'RENAME TABLE `#__bagallery_api` TO `#__gallery_api`',
            'RENAME TABLE `#__bagallery_tags` TO `#__gallery_tags`',
            'RENAME TABLE `#__bagallery_tags_map` TO `#__gallery_tags_map`',
            'RENAME TABLE `#__bagallery_colors` TO `#__gallery_colors`',
            'RENAME TABLE `#__bagallery_colors_map` TO `#__gallery_colors_map`'
        ];
        foreach ($array as $q) {
            $db->setQuery($q)
                ->execute();
        }
    }

    private function disablePlugins($type)
    {
        $this->enablePlugins($type, 0, 'bagallery');
    }

    private function enablePlugins($type, $enable = 1, $element = 'gallery')
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->update('#__extensions')
            ->set('enabled = ' . $enable)
            ->where('element = ' . $db->quote($element))
            ->where('folder = ' . $db->quote($type));
        $db->setQuery($query);
        $db->execute();
    }

    protected function clearCache()
    {
        $conf = Factory::getConfig();
        $options = [
            'defaultgroup' => '',
            'storage'      => $conf->get('cache_handler', ''),
            'caching'      => true,
            'cachebase'    => $conf->get('cache_path', JPATH_SITE . '/cache')
        ];
        $cache = Cache::getInstance('', $options);
        $data = $cache->getAll();
        if ($data) {
            foreach ($data as $item) {
                $cache->clean($item->group);
            }
        }
        $cache = Factory::getCache('');
        $cache->gc();
    }
}