<?php
/**
 * @package   BaGrid
 * @author    Balbooa http://www.balbooa.com/
 * @copyright Copyright @ Balbooa
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

use Joomla\CMS\Cache\Cache;
use Joomla\CMS\Factory;

defined('_JEXEC') or die;

class pkg_gridboxInstallerScript
{
    public function cleardir($dir)
    {
        if (!is_dir($dir)) {
            return;
        }
        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                filetype($dir."/".$object) == "dir" ? $this->cleardir($dir."/".$object) : unlink($dir."/".$object);
            }
        }
        reset($objects);
        rmdir($dir);
    }

    public function install($parent)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->update('#__template_styles')
            ->set('home = 0')
            ->where('`client_id` = 0')
            ->where('`home` = 1');
        $db->setQuery($query)
            ->execute();
        $query = $db->getQuery(true)
            ->update('#__template_styles')
            ->set('home = 1')
            ->where('`client_id` = 0')
            ->where('`template` = '.$db->quote('gridbox'));
        $db->setQuery($query)
            ->execute();
    }

    public function uninstall($parent){}

    public function update($parent)
    {
        $this->updateStructure('/components/com_gridbox/');
        $this->updateStructure('/administrator/components/com_gridbox/');
        $this->updateStructure('/plugins/finder/gridbox/');
        $this->updateStructure('/plugins/system/gridbox/');
    }

    private function updateStructure($path)
    {
        $path = JPATH_ROOT . $path;
        $files = ['controllers', 'helpers', 'models', 'views', 'gridbox.php', 'controller.php'];
        foreach ($files as $fileName) {
            $file = $path . $fileName;
            if (!file_exists($file)) {
                continue;
            }
            if (filetype($file) == "dir") {
                $this->cleardir($file);
            } else {
                unlink($file);
            }
        }
    }

    public function preflight($type, $parent)
    {
        if (JVERSION < '4.0.0') {
            Jerror::raiseWarning(null, 'Your Joomla version is outdated and incompatible with this extension. Update Joomla!');
            return false;
        }
    }

    public function postflight($type, $parent)
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->update('#__extensions')
            ->set('enabled = 1')
            ->where('element = '.$db->quote('gridbox'))
            ->where('folder = '.$db->quote('system'))
            ->where('type = '.$db->quote('plugin'));
        $db->setQuery($query);
        $db->execute();
        $custom = JPATH_ROOT. '/templates/gridbox/css/custom.css';
        if (!file_exists($custom)) {
            file_put_contents($custom, '');
        }
        $file = JPATH_ROOT. '/templates/gridbox/css/storage/responsive.css';
        if (file_exists($file)) {
            unlink($file);
        }
        $conf = Factory::getConfig();
        $options = ['defaultgroup' => '', 'storage' => $conf->get('cache_handler', ''),
            'caching' => true, 'cachebase' => $conf->get('cache_path', JPATH_SITE.'/cache')];
        $cache = Cache::getInstance('', $options);
        $data = $cache->getAll();
        if ($data) {
            foreach ($data as $item) {
                $cache->clean($item->group);
            }
        }
        $cache = Factory::getCache('');
        $cache->gc();
    }
}