/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

document.addEventListener('DOMContentLoaded', function(){
    var $ = jQuery;

    $('.tab-content').on('click', '.ba-group-element', function(event){
        top.app.messageData = $(this).find('> i')[0].className;
        top.app.messageListener();
    });

    $('.search-wrapper input[type="text"]').on('input', function(){
        var $this = this;
        clearTimeout(this.delay);
        this.delay = setTimeout(function(){
            var search = $this.value.toLowerCase();
            if (!search) {
                $('.row-fluid.tab-pane .ba-options-group > *').show();
                return;
            }
            $('.row-fluid.tab-pane .ba-options-group').each(function(){
                var count = 0,
                    elements = $(this).find('.ba-group-element');
                elements.each(function(){
                    var value = $(this).find('span').text().toLowerCase();
                    value = $.trim(value);
                    if (value.indexOf(search) < 0) {
                        this.style.display = 'none';
                        count++;
                    } else {
                        this.style.display = 'block';
                    }
                });
                if (count == elements.length) {
                    $(this).find('p').hide();
                } else {
                    $(this).find('p').show();
                }
            });
        }, 300);
    });

});