/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

class sortable {
    static  groups = {}
    
    constructor(element, settings) {
        this.options = $g.extend({}, this.defaults, typeof settings == 'object' && settings);
        if (element.sortable) {
            this.delete(element);
        }
        this.element = element;
        this.element.sortable = this;
        this.init();
    }

    delete(element) {
        $g(element).off('mousedown.sortable');
        element.sortable = null;
    }

    init() {
        let element = this.element,
            options = this.options,
            dragEl = null,
            cloneEl = null,
            placeEl = null,
            item = $g(element),
            div = document.createElement('div');
        if (!sortable.groups[options.group]) {
            sortable.groups[options.group] = [];
        }
        sortable.groups[options.group].unshift(item);
        item.on('mousedown.sortable', options.handle, function(event) {
            if (event.button != 0 || event.target.closest('.prevent-sortable') ||
                !options.beforeStart() ||
                (options.group == 'pages' && !event.target.classList.contains('sortable-handle')
                && (event.target.localName == 'a' || event.target.localName == 'i'))) {
                return;
            }
            $g(item).closest('.ba-wrapper').addClass('sortable-parent-node');
            options.start(item[0]);
            dragEl = $g(this).closest(element.children)[0];
            cloneEl = dragEl.cloneNode(true);
            $g(cloneEl).find('.ba-edit-item').parent().find('> *').not('.ba-edit-item').remove();
            placeEl = cloneEl.cloneNode(true);
            placeEl.classList.add('sortable-placeholder');
            cloneEl.classList.add('sortable-helper');
            dragEl.before(cloneEl);
            cloneEl.before(placeEl);
            $g(cloneEl).css({
                'width': $g(dragEl).width() + 'px',
                'position': 'fixed',
                'top': event.clientY + 'px',
                'left': event.clientX + 'px',
                'margin-left': 0,
                'transition': 'none'
            }).on('mouseover', function (event) {
                event.stopPropagation();
            });
            $g(dragEl).find('.edit-settings').trigger('mouseleave');
            div.append(dragEl);
            item.removeClass('active-item');
            $g(document).on('mousemove.sortable', function(event) {
                $g(cloneEl).css({
                    'top': event.clientY + 'px',
                    'left': event.clientX + 'px',
                });
                let target = null,
                    array = sortable.groups[options.group];
                for (let i = 0; i < array.length; i++) {
                    if (array[i].height() == 0) {
                        continue;
                    }
                    array[i].find(options.selector).not(placeEl).not(cloneEl).each(function() {
                        let rect = this.getBoundingClientRect();
                        if (rect.top < event.clientY && rect.bottom > event.clientY &&
                            rect.left < event.clientX && event.clientX < rect.right) {
                            target = this;
                            return false;
                        }
                    });
                    if (target) {
                        let rect = target.getBoundingClientRect(),
                            next = (event.clientY - rect.top) / (rect.bottom - rect.top) > .5,
                            after = next && target.nextSibling || target;
                        if (next && !target.nextSibling) {
                            after.parentNode.append(placeEl);
                        } else {
                            after.parentNode.insertBefore(placeEl, after);
                        }
                    } else {
                        let rect = array[i][0].getBoundingClientRect(),
                            length = $g(array[i][0]).find(options.selector)
                                .not(placeEl).not(cloneEl).length;
                        if (rect.top < event.clientY && rect.bottom > event.clientY &&
                            rect.left < event.clientX && event.clientX < rect.right && length == 0) {
                            target = array[i][0];
                        }
                        if (target && !target.classList.contains('custom-sidebar-items')) {
                            target.append(placeEl);
                        } else if (target) {
                            $g(target).find('> .add-custom-sidebar-items').before(placeEl);
                        }
                    }
                    if (target) {
                        break;
                    }
                }
                return false;
            }).off('mouseup.sortable').on('mouseup.sortable', function (){
                cloneEl.parentNode.removeChild(cloneEl);
                placeEl.parentNode.insertBefore(dragEl, placeEl);
                placeEl.parentNode.removeChild(placeEl);
                $g(document).off('mousemove.sortable mouseup.sortable');
                $g('.sortable-parent-node').removeClass('sortable-parent-node');
                options.change(dragEl);
            });
            return false;
        });
    }
}

sortable.prototype.defaults = {
    selector: '> *',
    change: function(el){
        $g(el).trigger('change');
    },
    start: function(){},
    beforeStart: () => {
        return true;
    }
}