export default class AuthorSelect
{
    static setEvents()
    {
        $g('.ba-custom-author-select').off('click.select').on('click.select', 'li', function(){
            let parent = $(this).closest('.ba-custom-author-select'),
                text = this.textContent.trim(),
                image = this.dataset.image,
                authors = [],
                lis = parent.find('li[data-value]'),
                val = this.dataset.value,
                str = '<span class="selected-author" data-id="'+val;
            str += '"><span class="ba-author-avatar" style="background-image: url(';
            str += image.replace(/\s/g, '%20')+')"></span><span class="ba-author-name">'+text+'</span>';
            str += '<i class="zmdi zmdi-close remove-selected-author"></i></span>';
            parent.before(str);
            parent.parent().find('.selected-author').each((i, author) =>{
                authors.push(author.dataset.id);
            });
            lis.each((i, li) => {
                if (authors.indexOf(li.dataset.value) == -1) {
                    li.style.display = ''
                } else {
                    li.style.display = 'none';
                }
            });
            if (lis.length == authors.length) {
                $g('.select-post-author').hide();
            } else {
                $g('.select-post-author').css('display', '');
            }
            parent.find('input[type="hidden"]').val(authors.join(','));
            parent.trigger('customAction');
        });
        $g('.ba-custom-author-select')
            .off('click.open-select')
            .on('click.open-select', 'input,  > i', function(event){
            event.stopPropagation();
            let select = $g(this).closest('.ba-custom-author-select');
            AuthorSelect.showSelect(select);
        });
        $g('#bulk-author-modal .ba-custom-author-select-wrapper')
            .off('click.open-select')
            .on('click.open-select', function(event){
            if (event.target && event.target.closest('.ba-custom-author-select')) return;
                const select = $g(this).find('.ba-custom-author-select');
                AuthorSelect.showSelect(select);
        })

        $g('.ba-custom-author-select-wrapper').off('click.selected-author')
            .on('click.selected-author', '.remove-selected-author', function(event){
            event.stopPropagation();
            this.parentNode.remove();
            let authors = [],
                li = $g('.select-post-author li[data-value]');
            $g('.selected-author').each(function(){
                authors.push(this.dataset.id);
            });
            li.each(function(){
                if (authors.indexOf(this.dataset.value) == -1) {
                    this.style.display = '';
                } else {
                    this.style.display = 'none';
                }
            });
            if (li.length == authors.length) {
                $g('.select-post-author').hide();
            } else {
                $g('.select-post-author').css('display', '');
            }
            const author = authors.join(',');
            $g('.select-post-author input[type="hidden"]').val(author).trigger('customAction');
        });
    }

    static showSelect(select)
    {
        if (select.find('ul').hasClass('visible-select')) {
            return;
        }
        $g('.visible-select').removeClass('visible-select');
        select.find('ul').addClass('visible-select');
        select.trigger('show');
        setTimeout(function(){
            $g('body').one('click', function(){
                $g('.visible-select').removeClass('visible-select');
            });
        }, 50);
    }

    static setAuthors(authors)
    {
        $g('.select-post-author').each(function(){
            $g('span.selected-author').remove();
            let author = [],
                li = $g(this).find('li[data-value]'),
                authorId = '';
            const len = authors.length;
            for (let i = 0; i < len; i++) {
                if (!authors[i].avatar) {
                    authors[i].avatar = 'components/com_gridbox/assets/images/default-user.png';
                }
                let str = '<span class="selected-author" data-id="'+authors[i].id
                str += '"><span class="ba-author-avatar" style="background-image: url(';
                str += JUri + authors[i].avatar.replace(/\s/g, '%20')+')"></span><span class="ba-author-name">' + authors[i].title + '</span>';
                str += '<i class="zmdi zmdi-close remove-selected-author"></i></span>';
                $g(this).before(str);
                author.push(authors[i].id);
            }
            li.each(function(){
                this.style.display = author.indexOf(this.dataset.value) == -1 ? '' : this.style.display = 'none';
            });
            if (li.length == author.length) {
                $g('.select-post-author').hide();
            } else {
                $g('.select-post-author').css('display', '');
            }
            authorId = author.join(',');
            this.querySelector('input[type="hidden"]').value = authorId;
        });
    }
}