
export default class BulkActions
{
    static actions = {
        'bulkAccess': 'bulk-access-modal',
        'bulkLanguage': 'bulk-language-modal',
        'bulkTheme': 'bulk-themes-modal',
        'bulkCategories': 'bulk-categories-modal',
        'bulkAuthor': 'bulk-author-modal',
        'bulkTags': 'bulk-tags-modal'
    }
    static view = '';
    static action = '';
    static modal = null;
    static applyBtn = null;

    static checkAction(task)
    {
        this.prepareAction(task);

        return this.action in this.actions
    }

    static prepareAction(task)
    {
        const params = task.split('.');
        this.view = params[0];
        this.action = params[1];
    }

    static setEvents()
    {
        for (let ind in this.actions) {
            const modalId = this.actions[ind];
            const modal = $g(`#${modalId}`);
            modal.on('tagsUpdated', this.updateTags.bind(this));
            modal.on('customAction', this.setValue.bind(this))
            modal.on('multiAction', this.setCategoriesValue.bind(this));
            modal.on('click', '.apply-bulk-action', this.submitBulkAction.bind(this));
        }

        this.appendBulkValueInput();
    }

    static updateTags()
    {
        const tags = []
        this.modal.find('select option').each((i, option) => {
            tags.push(option.value);
        });
        this.value = tags.join(',');
        this.applyBtn.addClass('active-button');
    }

    static setCategoriesValue()
    {
        const data = {
            default: this.modal.find('input[data-property="category"]')[0].value,
            categories: this.modal.find('input[data-property="categories"]')[0].value
        }
        this.value = JSON.stringify(data);
        this.applyBtn.addClass('active-button');
    }

    static appendBulkValueInput()
    {
        this.input = document.createElement('input');
        this.input.type = 'hidden';
        this.input.name = 'bulk-value';
        document.adminForm.append(this.input);
    }

    static setValue() {
        this.value = this.modal.find('input[type="hidden"]')[0].value;
        this.applyBtn.addClass('active-button');
    }

    static submitBulkAction(event) {
        event.preventDefault();
        if (!this.applyBtn.hasClass('active-button')) {
            return;
        }
        const task = this.view + '.' + this.action;
        this.modal.modal('hide');
        this.input.value = this.value;
        Joomla.submitform(task);
    }

    static showModal() {
        const modalId = this.actions[this.action];
        this.modal = $g(`#${modalId}`);
        this.modal.find('input').val('');
        if (this.action == 'bulkAuthor') {
            app.AuthorSelect.setAuthors([])
        } else if (this.action == 'bulkTags') {
            app.TagsSelect.setTags([])
        }
        this.applyBtn = this.modal.find('.apply-bulk-action').removeClass('active-button');
        this.modal.modal();
    }
}