export default class Multicategory
{
    static select = null;

    static start()
    {
        if (!document.querySelector('template.page-multicategory-list')) {
            return;
        }
        let $this = this,
            clone = document.querySelector('template.page-multicategory-list').content.cloneNode(true);
        document.body.append(clone);
        $this.ul = document.querySelector('ul.page-multicategory-list');
        $this.li = $this.ul.querySelectorAll('li');
        app.setTooltip($this.ul);
        $g($this.ul).on('change', 'input[type="checkbox"]', function(){
            let li = this.closest('li')
            if (!this.checked && li.classList.contains('default-category')) {
                this.checked = true;
            }
        }).on('click', '.set-default-page-category', function(){
            let li = this.closest('li')
            if (li.classList.contains('default-category')) {
                return;
            }
            $this.ul.querySelectorAll('li.default-category').forEach((category) => {
                category.classList.remove('default-category');
                category.querySelector('input').checked = false;
            });
            li.classList.add('default-category');
            li.querySelector('input').checked = true;
        });
        $g('body').on('click', '.page-multicategory-select input, .page-multicategory-select > i', function(){
            let ul = $this.ul;
            if (ul.classList.contains('visible-select')) {
                return;
            }
            $this.select = $g(this).closest('.page-multicategory-select');
            if (this.closest('#bulk-categories-modal')) {
                app.multicategory.set(0, []);
            }
            $this.backdrop = document.createElement('div');
            $this.backdrop.classList.add('page-multicategory-backdrop');
            $this.backdrop.addEventListener('click', $this.hide.bind($this));
            document.body.append($this.backdrop);
            ul.classList.add('visible-select');
        })
    }

    static hide(){
        const data = this.getData();
        this.ul.classList.remove('visible-select');
        this.backdrop.remove();
        if (data.category.id != 0) {
            this.updateInput(data);
        }
    }

    static getData()
    {
        let data = {
            category: {
                id: 0,
                title: ''
            },
            id : [],
            title: []
        };
        const hasDefault = this.ul.querySelector('.default-category');
        this.ul.querySelectorAll('input[type="checkbox"]').forEach((input) => {
            let li = input.closest('li');
            if (li.classList.contains('default-category')
                || (!hasDefault && data.category.id == 0 && input.checked)) {
                data.category.id = li.dataset.value;
                data.category.title = li.querySelector('.multicategory-title').textContent.trim();
            } else if (input.checked) {
                data.id.push(li.dataset.value);
                data.title.push(li.querySelector('.multicategory-title').textContent.trim());
            }
        });

        return data;
    }

    static updateInput(data)
    {
        data.title.unshift(data.category.title);
        this.select.find('input').each(function(){
            this.value = this.type == 'text'
                ? data.title.join(', ')
                : (this.dataset.property == 'category'
                    ? data.category.id
                    : data.id.join(','));
        });
        this.select.trigger('multiAction');
    }

    static setActive(id, isDefault)
    {
        let title = '';
        this.li.forEach((li) => {
            if (li.dataset.value == id) {
                li.querySelector('input[type="checkbox"]').checked = true;
                li.classList[isDefault ? 'add' : 'remove']('default-category');
                title = li.querySelector('.multicategory-title').textContent.trim();
            }
        });

        return title;
    }
    static set(category, categories)
    {
        this.li.forEach((li) => {
            li.querySelector('input[type="checkbox"]').checked = false;
            li.classList.remove('default-category');
        });
        let array = [];
        array.push(this.setActive(category, true));
        categories.forEach((obj) => {
            array.push(this.setActive(obj.category_id, false));
        });

        return array.join(', ');
    }
}