export default class TagsSelect
{
    static show($this, position = 'left')
    {
        fontBtn = $this;
        $g('#post-tags-dialog .ba-settings-item[data-id]').each(function(){
            const action = document.querySelector('.meta-tags option[value="' + this.dataset.id + '"]') ? 'add' : 'remove'
            this.classList[action]('selected');
        });
        showDataTagsDialog('post-tags-dialog', 10, position);
    }

    static setEvents()
    {
        $g('.meta-tags .picked-tags .search-tag input').on('keyup', function(event){
            let title = this.value.trim();
            if (event.keyCode == 13 && title) {
                let str = '<li class="tags-chosen"><span>',
                    tagId = 'new$'+title;
                $g('#post-tags-dialog .ba-settings-item').each(function(){
                    if (title == this.textContent.trim()) {
                        tagId = this.dataset.id;
                        return false;
                    }
                });
                if (tagId != 'new$'+title || document.querySelector('.picked-tags .tags-chosen i[data-remove="'+tagId+'"]')) {
                    return;
                }
                str += title+'</span><i class="zmdi zmdi-close" data-remove="'+tagId+'"></i></li>';
                $g('.picked-tags .search-tag').before(str);
                str = '<option value="'+tagId+'" selected>'+title+'</option>';
                $g('select.meta_tags').append(str);
                this.value = '';
                event.stopPropagation();
                event.preventDefault();
                return false;
            }
        });
        $g('#bulk-tags-modal .picked-tags').on('click', function(event){
            if (event.target && event.target.closest('.tags-chosen')) return;
            TagsSelect.show(this, 'right');
        });

        $g('.meta-tags .picked-tags').on('click', '.zmdi.zmdi-close', function(){
            let id = $g(this).attr('data-remove');
            $g('select.meta_tags option[value="'+id+'"]').remove();
            this.closest('li').remove();
            $g('select.meta_tags').trigger('tagsUpdated');
        });

        $g('.select-post-tags').on('click', function(){
            TagsSelect.show(this)
        });

        $g('#post-tags-dialog .modal-body').on('change', '.select-data-tags-type', function(){
            let modal = $g('#post-tags-dialog');
            modal.find('.ba-settings-item[data-id]').hide();
            modal.find('.search-post-tags').value = '';
            modal.find('.ba-settings-item[data-id]'+(this.value != 1 ? '[data-folder="'+this.value+'"]' : '')).css('display', '');
        });
        $g('#post-tags-dialog .modal-body').on('input', '.search-post-tags', function(){
            let modal = $g('#post-tags-dialog'),
                search = this.value.trim().toLowerCase(),
                folder = modal.find('.select-data-tags-type').val();
            modal.find('.ba-settings-item[data-id]').hide();
            modal.find('.ba-settings-item[data-id]').each(function(){
                if (folder == this.dataset.folder || folder == 1) {
                    let title = this.querySelector('.ba-settings-item-title').textContent.trim().toLowerCase();
                    this.style.display = (search === '' || title.indexOf(search) != -1 ? '' : 'none');
                }
            });
        });
        $g('#post-tags-dialog .modal-body').on('click', '.post-tags-wrapper .ba-settings-input-type', function(){
            let id = this.dataset.id,
                title = this.textContent.trim(),
                str = '';
            if (document.querySelector('.meta-tags option[value="'+id+'"]')) {
                return;
            }
            this.classList.add('selected');
            str = '<li class="tags-chosen"><span>'+title+'</span><i class="zmdi zmdi-close" data-remove="'+id+'"></i></li>';
            $g('.picked-tags .search-tag').before(str);
            str = '<option value="'+id+'" selected>'+title+'</option>';
            $g('select.meta_tags').append(str).trigger('tagsUpdated');
        });
    }

    static setTags(tags)
    {
        $g('select.meta_tags').empty()
        $g('.picked-tags .tags-chosen').remove();
        for (var i = 0; i < tags.length; i++) {
            var title = tags[i].title,
                tagId = tags[i].id,
                str = '<li class="tags-chosen"><span>';
            str += title+'</span><i class="zmdi zmdi-close" data-remove="'+tagId+'"></i></li>';
            $g('.picked-tags .search-tag').before(str);
            str = '<option value="'+tagId+'" selected>'+title+'</option>';
            $g('select.meta_tags').append(str);
        }
        $g('.meta-tags .picked-tags .search-tag input').val('');
    }
}