<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined('_JEXEC') or die;

use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\Component\Router\RouterFactoryInterface;
use Joomla\CMS\Extension\Service\Provider\RouterFactory;
use Joomla\CMS\Association\AssociationExtensionInterface;
use Balbooa\Component\Gridbox\Site\Helper\AssociationsHelper;
use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
use Balbooa\Component\Gridbox\Administrator\Extension\GridboxComponent;

return new class implements ServiceProviderInterface {
    
    public function register(Container $container): void
    {
        $container->set(AssociationExtensionInterface::class, new AssociationsHelper());
        $container->registerServiceProvider(new MVCFactory('\\Balbooa\\Component\\Gridbox'));
        $container->registerServiceProvider(new ComponentDispatcherFactory('\\Balbooa\\Component\\Gridbox'));
        $container->registerServiceProvider(new RouterFactory('\\Balbooa\\Component\\Gridbox'));
        $container->set(
            ComponentInterface::class,
            function (Container $container) {
                $component = new GridboxComponent($container->get(ComponentDispatcherFactoryInterface::class));
                $component->setMVCFactory($container->get(MVCFactoryInterface::class));
                $component->setRouterFactory($container->get(RouterFactoryInterface::class));
                $component->setAssociationExtension($container->get(AssociationExtensionInterface::class));

                return $component;
            }
        );
    }
};