<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\File;
use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\Folder;
use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Site\Helper\AssetsHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;

class AppsController extends AdminController
{
    public $variations;

    public function getModel($name = 'Gridbox', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function getDefaultsSeo()
    {
        $id = $this->input->get('id', 0, 'int');
        $type = $this->input->get('type', '', 'string');
        $model = $this->getModel('Apps');
        $seo = $model->getDefaultsSeo($id, $type);
        $str = json_encode($seo);
        echo $str;
        exit;
    }

    public function setDefaultsSeo()
    {
        $seo = (object)[
            'id' => $this->input->get('id', 0, 'int'),
            'item_id' => $this->input->get('item_id', 0, 'int'),
            'item_type' => $this->input->get('item_type', '', 'string'),
            'meta_title' => $this->input->get('meta_title', '', 'string'),
            'meta_description' => $this->input->get('meta_description', '', 'string'),
            'share_image' => $this->input->get('share_image', '', 'string'),
            'share_title' => $this->input->get('share_title', '', 'string'),
            'share_description' => $this->input->get('share_description', '', 'string'),
            'sitemap_include' => $this->input->get('sitemap_include', '', 'string'),
            'changefreq' => $this->input->get('changefreq', '', 'string'),
            'priority' => $this->input->get('priority', '', 'string'),
            'schema_markup' => $this->input->get('schema_markup', '', 'raw')
        ];
        $model = $this->getModel('Apps');
        $model->setDefaultsSeo($seo);
        exit;
    }

    public function importCSV()
    {
        $config = Factory::getConfig();
        $tmp_path = $config->get('tmp_path');
        $file = $tmp_path.'/gridbox.csv';
        $matched = $this->input->get('matched', '{}', 'raw');
        $id = $this->input->get('id', 0, 'int');
        $overwrite = $this->input->get('overwrite', 0, 'int');
        $type = $this->input->get('type', '{}', 'string');
        $item = $this->input->files->get('file');
        File::upload($item['tmp_name'], $file);
        $model = $this->getModel('Apps');
        $obj = json_decode($matched);
        $category = $this->getModel('Category');
        $model->importCSV($file, $id, $overwrite, $obj, $type, $category);
    }

    public function checkMatchedCsv()
    {
        $config = Factory::getConfig();
        $tmp_path = $config->get('tmp_path');
        $file = $tmp_path.'/gridbox.csv';
        $matched = $this->input->get('matched', '{}', 'raw');
        $id = $this->input->get('id', 0, 'int');
        $overwrite = $this->input->get('overwrite', 0, 'int');
        $item = $this->input->files->get('file');
        File::upload($item['tmp_name'], $file);
        $model = $this->getModel('apps');
        $obj = json_decode($matched);
        $model->checkMatchedCsv($file, $id, $overwrite, $obj);
    }

    public function checkGridboxCsv()
    {
        $config = Factory::getConfig();
        $tmp_path = $config->get('tmp_path');
        $file = $tmp_path.'/gridbox.csv';
        $id = $this->input->get('id', 0, 'int');
        $overwrite = $this->input->get('overwrite', 0, 'int');
        $item = $this->input->files->get('file');
        File::upload($item['tmp_name'], $file);
        $model = $this->getModel('apps');
        $model->checkGridboxCsv($file, $id, $overwrite);
    }

    public function getMatchFields()
    {
        $config = Factory::getConfig();
        $tmp_path = $config->get('tmp_path');
        $file = $tmp_path.'/gridbox.csv';
        $id = $this->input->get('id', 0, 'int');
        $item = $this->input->files->get('file');
        File::upload($item['tmp_name'], $file);
        $handle = fopen($file, "r");
        $model = $this->getModel('apps');
        $obj = new \stdClass();
        $obj->data = fgetcsv($handle, 1000, ",");
        $obj->cells = $model->getCSVAppCells();
        $obj->fields = $model->getAppFields($id);
        fclose($handle);
        File::delete($file);
        $str = json_encode($obj);
        print_r($str);exit;
        exit;
    }

    public function getAppCells()
    {
        $id = $this->input->get('id', 0, 'int');
        $pks = $this->input->get('pks', [], 'array');
        $model = $this->getModel('apps');
        $model->getAppCells($id, $pks);
    }

    public function exportCSV()
    {
        $model = $this->getModel('apps');
        $id = $this->input->get('id', 0, 'int');
        $pks = $this->input->get('pks', [], 'array');
        $cells = $this->input->get('cells', [], 'array');
        $config = Factory::getConfig();
        $tmp_path = $config->get('tmp_path');
        $response = new \stdClass();
        if (!empty($tmp_path) && Folder::exists($tmp_path)) {
            $response->file = $model->exportCSV($id, $pks, $cells, $tmp_path);
            $response->status = true;
        } else {
            $response->status = false;
            $response->message = 'Temp Folder is not exists';
        }
        $str = json_encode($response);
        print_r($str);
        exit();
    }

    public function download()
    {
        $file = $this->input->get('file', '', 'string');
        if (file_exists($file)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename=gridbox-products.csv');
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: '.filesize($file));
            if (readfile($file)) {
                unlink($file);
            }
        }
        exit;
    }

    public function setFeatured()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $featured = $input->get('featured', 0, 'int');
        $model = $this->getModel();
        $model->setFeatured($id, $featured);
        exit();
    }

    public function moveTo()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel('category');
        $input = Factory::getApplication()->input;
        $data = $input->get('category_id', '', 'string');
        $obj = json_decode($data);
        $cid = $input->get('cid', [], 'array');
        foreach ($cid as $id) {
            $model->pageMoveTo($obj->id, $id, $obj->app_id);
        }
        GridboxHelper::ajaxReload('SUCCESS_MOVED');
    }

    public function pageMoveTo()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel('category');
        $input = Factory::getApplication()->input;
        $data = $input->get('category_id', '', 'string');
        $obj = json_decode($data);
        $id = $input->get('context-item', 0, 'int');
        $model->pageMoveTo($obj->id, $id, $obj->app_id);
        GridboxHelper::ajaxReload('SUCCESS_MOVED');
    }

    public function orderCategories()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel('category');
        $model->orderCategories();
        exit();
    }

    public function updateCategory()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('category-id', '', 'string');
        if (GridboxHelper::assetsCheckPermission($id, 'category', 'core.edit', '')) {
            $model = $this->getModel('Category');
            $model->updateCategory();
            GridboxHelper::ajaxReload('JLIB_APPLICATION_SAVE_SUCCESS');
        } else {
            GridboxHelper::ajaxReload('JLIB_APPLICATION_ERROR_EDIT_NOT_PERMITTED');
        }
    }

    public function deleteCategory()
    {
        $input = Factory::getApplication()->input;
        $data = $input->get('context-item', '', 'string');
        $obj = json_decode($data);
        $model = $this->getModel('category');
        if ($model->checkDeletePermissions($obj)) {
            $model->removeCategory();
            GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
        } else {
            GridboxHelper::ajaxReload('JERROR_CORE_DELETE_NOT_PERMITTED');
        }
    }

    public function categoryMoveTo()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel('category');
        $model->moveTo();
        GridboxHelper::ajaxReload('SUCCESS_MOVED');
    }

    public function categoryDuplicate()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $model = $this->getModel('category');
        $gridboxModel = $this->getModel();
        $model->duplicate($id, $gridboxModel);
        GridboxHelper::ajaxReload('GRIDBOX_DUPLICATED');
    }

    public function applySettings()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('blog', 0, 'int');
        $user = Factory::getUser();
        if ($user->authorise('core.edit.app.'.$id, 'com_gridbox')) {
            $model = $this->getModel();
            $model->applySettings();
            GridboxHelper::ajaxReload('JLIB_APPLICATION_SAVE_SUCCESS');
        } else {
            GridboxHelper::ajaxReload('JLIB_APPLICATION_ERROR_EDIT_NOT_PERMITTED');
        }
    }

    public function addCategory()
    {
        $input = Factory::getApplication()->input;
        $parent = $input->get('parent_id', 0, 'int');
        $blog = $input->get('blog', 0, 'int');
        $obj = new \stdClass();
        if (!empty($parent)) {
            $id = $parent;
            $type = 'category';
        } else {
            $id = $blog;
            $type = 'app';
        }
        if (GridboxHelper::assetsCheckPermission($id, $type, 'core.create', '')) {
            $model = $this->getModel('category');
            $title = $input->get('category_name', '', 'string');
            $order = $input->get('category_order_list', 0, 'int');
            $obj->id = $model->createCat($title, $blog, $parent, $order);
            $obj->msg = Text::_('ITEM_CREATED');
        } else {
            $obj->id = 0;
            $obj->msg = Text::_('JERROR_CORE_CREATE_NOT_PERMITTED');
        }
        $str = json_encode($obj);
        echo $str;
        exit();
    }

    public function publish()
    {
        $cid = Factory::getApplication()->input->get('cid', [], 'array');
        $task = $this->getTask();
        if ($task != 'unpublish') {
            $text = $this->text_prefix.'_N_ITEMS_PUBLISHED';
        } else {
            $text = $this->text_prefix.'_N_ITEMS_UNPUBLISHED';
        }
        foreach ($cid as $pk) {
            $assets = new AssetsHelper($pk, 'page');
            $flag = $assets->checkPermission('core.edit.state');
            if (!$flag) {
                break;
            }
        }
        if ($flag) {
            parent::publish();
        } else {
            $text = 'JLIB_APPLICATION_ERROR_EDITSTATE_NOT_PERMITTED';
        }
        GridboxHelper::ajaxReload($text);
    }

    public function addTrash()
    {
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        foreach ($pks as $pk) {
            $assets = new AssetsHelper($pk, 'page');
            $flag = $assets->checkPermission('core.delete');
            if (!$flag) {
                break;
            }
        }
        if ($flag) {
            $model = $this->getModel();
            $model->trash($pks);
            GridboxHelper::ajaxReload($this->text_prefix . '_N_ITEMS_TRASHED');
        } else {
            GridboxHelper::ajaxReload('JERROR_CORE_DELETE_NOT_PERMITTED');
        }
    }

    public function contextTrash()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $assets = new AssetsHelper($id, 'page');
        $flag = $assets->checkPermission('core.delete');
        if ($flag) {
            $array = array($id);
            $model = $this->getModel();
            $model->trash($array);
            GridboxHelper::ajaxReload($this->text_prefix . '_N_ITEMS_TRASHED');
        } else {
            GridboxHelper::ajaxReload('JERROR_CORE_DELETE_NOT_PERMITTED');
        }
    }
    
    public function contextDuplicate()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $array = [];
        $array[] = $id;
        $model = $this->getModel();
        $model->duplicate($array);
        GridboxHelper::ajaxReload('GRIDBOX_DUPLICATED');
    }
    
    public function duplicate()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $blog = $this->input->get('blog', 0, 'int');
        $model = $this->getModel();
        $model->duplicate($pks);
        GridboxHelper::ajaxReload('gridbox_DUPLICATED');
    }

    public function getTags()
    {
        GridboxHelper::checkUserEditLevel();
        $tags = GridboxHelper::getTags();
        $json = json_encode($tags);
        echo $json;
        exit;
    }
}