<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Associations;
use Joomla\CMS\MVC\Controller\FormController;

class AssociationsController extends FormController
{
    /**
     * @return \Balbooa\Component\Gridbox\Administrator\Model
    */
    public function getModel($name = '', $prefix = '', $config = ['ignore_request' => false])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function setCookie()
    {
        $key = $this->input->get('key', '', 'string');
        $value = $this->input->get('value', '', 'string');
        setcookie($key, $value, time()+7200);
        exit;
    }

    public function getLinks()
    {
        $id = $this->input->get('id', 0, 'int');
        $type = $this->input->get('type', '', 'string');
        $model = $this->getModel();
        $data = $model->getLinks($id, $type);
        $str = json_encode($data);
        echo $str;
        exit;
    }

    public function saveLinks()
    {
        if (Associations::isEnabled()) {
            $id = $this->input->get('id', 0, 'int');
            $type = $this->input->get('type', '', 'string');
            $items = $this->input->get('items', [], 'array');
            $model = $this->getModel();
            $model->saveLinks($id, $type, $items);
        }
        exit;
    }
}