<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\AdminController;

class AuthorsController extends AdminController
{
    /**
     * @return Balbooa\Component\Gridbox\Administrator\Model
    */
    public function getModel($name = 'Authors', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function checkUser()
    {
        GridboxHelper::checkUserEditLevel();
        $id = $this->input->get('id', '', 'int');
        $currentUser = $this->input->get('currentUser', '', 'int');
        $model = $this->getModel();
        $result = $model->checkUser($id, $currentUser);
        print_r($result);exit;
    }

    public function updateAuthors()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->updateAuthors();
        GridboxHelper::ajaxReload('JLIB_APPLICATION_SAVE_SUCCESS');
    }

    public function addAuthor()
    {
        GridboxHelper::checkUserEditLevel();
        $title = $this->input->get('tag_name', '', 'string');
        $user = $this->input->get('user_id', 0, 'int');
        $model = $this->getModel();
        $model->addAuthor($title, $user);
        GridboxHelper::ajaxReload('ITEM_CREATED');
    }

    public function delete()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $model = $this->getModel();
        $model->delete($pks);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function contextDelete()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $array = [$id];
        $model = $this->getModel();
        $model->delete($array);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function publish()
    {
        GridboxHelper::checkUserEditLevel();
        $task = $this->getTask();
        if ($task != 'unpublish') {
            $value = 1;
            $text = $this->text_prefix . '_N_ITEMS_PUBLISHED';
        } else {
            $value = 0;
            $text = $this->text_prefix . '_N_ITEMS_UNPUBLISHED';
        }
        $cid = Factory::getApplication()->input->get('cid', [], 'array');
        $model = $this->getModel();
        $model->publish($cid, $value);
        GridboxHelper::ajaxReload($text);
    }
}