<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\File;
use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\Folder;
use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Site\Helper\Dashboard\SalesHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\AdminController;

class OrdersController extends AdminController
{
    public function getModel($name = 'Orders', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function testOrder()
    {
        $id = $this->input->get('id', 0, 'int');
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('o.*, p.type')
            ->from('#__gridbox_store_orders AS o')
            ->leftJoin('#__gridbox_store_orders_payment AS p ON p.order_id = o.id');
        if (!empty($id)) {
            $query->where('o.id = '.$id);
        } else {
            $query->where('o.published <> 1');
        }
        $db->setQuery($query);
        $orders = $db->loadObjectList();
        if (!empty($id)) {
            foreach ($orders as $order) {
                $query = $db->getQuery(true)
                    ->select('value, title')
                    ->from('#__gridbox_store_order_customer_info')
                    ->where('order_id = '.$id);
                $db->setQuery($query);
                $order->info = $db->loadObjectList();
            }

        }

        print_r($orders);

        exit;
    }

    public function checkMatchedCsv()
    {
        $config = Factory::getConfig();
        $tmp_path = $config->get('tmp_path');
        $file = $tmp_path.'/gridbox.csv';
        $matched = $this->input->get('matched', '{}', 'raw');
        $overwrite = $this->input->get('overwrite', 0, 'int');
        $item = $this->input->files->get('file');
        File::upload($item['tmp_name'], $file);
        $model = $this->getModel();
        $obj = json_decode($matched);
        $model->checkMatchedCsv($file, $overwrite, $obj);
    }

    public function checkGridboxCsv()
    {
        $config = Factory::getConfig();
        $tmp_path = $config->get('tmp_path');
        $file = $tmp_path.'/gridbox.csv';
        $overwrite = $this->input->get('overwrite', 0, 'int');
        $item = $this->input->files->get('file');
        File::upload($item['tmp_name'], $file);
        $model = $this->getModel();
        $model->checkGridboxCsv($file, $overwrite);
    }

    public function importCSV()
    {
        $config = Factory::getConfig();
        $tmp_path = $config->get('tmp_path');
        $file = $tmp_path.'/gridbox.csv';
        $matched = $this->input->get('matched', '{}', 'raw');
        $overwrite = $this->input->get('overwrite', 0, 'int');
        $type = $this->input->get('type', '{}', 'string');
        $item = $this->input->files->get('file');
        File::upload($item['tmp_name'], $file);
        $model = $this->getModel();
        $obj = json_decode($matched);
        $category = $this->getModel('category');
        $model->importCSV($file, $overwrite, $obj, $type, $category);
        exit;
    }

    public function getMatchFields()
    {
        $config = Factory::getConfig();
        $tmp_path = $config->get('tmp_path');
        $file = $tmp_path.'/gridbox.csv';
        $id = $this->input->get('id', 0, 'int');
        $item = $this->input->files->get('file');
        File::upload($item['tmp_name'], $file);
        $handle = fopen($file, "r");
        $model = $this->getModel();
        $obj = new \stdClass();
        $obj->data = fgetcsv($handle, 1000, ",");
        $obj->cells = $model->getCSVAppCells();
        $obj->fields = $model->getAppFields($id);
        fclose($handle);
        File::delete($file);
        $str = json_encode($obj);
        print_r($str);exit;
    }

    public function download()
    {
        $file = $this->input->get('file', '', 'string');
        if (file_exists($file)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename=gridbox-orders.csv');
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: '.filesize($file));
            if (readfile($file)) {
                unlink($file);
            }
        }
        exit;
    }

    public function exportCSV()
    {
        $model = $this->getModel();
        $pks = $this->input->get('pks', [], 'array');
        $cells = $this->input->get('cells', [], 'array');
        $config = Factory::getConfig();
        $tmp_path = $config->get('tmp_path');
        $response = new \stdClass();
        if (!empty($tmp_path) && Folder::exists($tmp_path)) {
            $response->file = $model->exportCSV($pks, $cells, $tmp_path);
            $response->status = true;
        } else {
            $response->status = false;
            $response->message = 'Temp Folder is not exists';
        }
        $str = json_encode($response);
        print_r($str);
        exit();
    }

    public function getAppCells()
    {
        $pks = $this->input->get('pks', [], 'array');
        $model = $this->getModel();
        $model->getAppCells($pks);
    }

    public function setTracking()
    {
        $obj = new \stdClass();
        $obj->id = $this->input->get('id', 0, 'int');
        $obj->order_id = $this->input->get('order_id', 0, 'int');
        $obj->number = $this->input->get('number', '', 'string');
        $obj->url = $this->input->get('url', '', 'string');
        $obj->title = $this->input->get('title', '', 'string');
        $model = $this->getModel();
        $obj = $model->setTracking($obj);
        $str = json_encode($obj);
        echo $str;exit();
    }

    public function getUserInfo()
    {
        $id = $this->input->get('id', 0, 'int');
        $model = $this->getModel();
        $info = $model->getUserInfo($id);
        $str = json_encode($info);
        echo $str;exit();
    }

    public function getStatistic()
    {
        $input = Factory::getApplication()->input;
        $date = $input->get('date', '', 'string');
        $type = $input->get('type', '', 'string');
        $data = SalesHelper::make()->getShopStatistic($date, $type);
        $str = json_encode($data);
        echo $str;
        exit;
    }

    public function getOrder()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $model = $this->getModel();
        $order = $model->getOrder($id);
        $str = json_encode($order);
        print_r($str);exit;
    }

    public function updateOrder()
    {
        $input = Factory::getApplication()->input;
        $data = $input->get('data', '', 'string');
        $object = json_decode($data);
        $user_id = 0;
        if (isset($object->info->{'user_id'})) {
            $user_id = $object->info->{'user_id'};
            unset($object->info->{'user_id'});
        }
        $model = $this->getModel();
        $model->updateOrder($object, $user_id);
        print_r('{}');exit;
    }

    public function createOrder()
    {
        $input = Factory::getApplication()->input;
        $data = $input->get('data', '', 'string');
        $object = json_decode($data);
        $user_id = 0;
        if (isset($object->info->user_id)) {
            $user_id = $object->info->{'user_id'};
            unset($object->info->user_id);
        }
        $model = $this->getModel();
        $model->createOrder($object, $user_id);
        print_r('{}');exit;
    }

    public function updateStatus()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $status = $input->get('status', '', 'string');
        $comment = $input->get('comment', '', 'string');
        $model = $this->getModel();
        $model->updateStatus($id, $status, $comment);
        echo '{}';exit;
    }

    public function getStatus()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $model = $this->getModel();
        $obj = $model->getStatus($id);
        $str = json_encode($obj);
        echo $str;exit;
    }

    public function contextDelete()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = [$this->input->get('context-item', 0, 'int')];
        $model = $this->getModel();
        $model->delete($pks);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function delete()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $model = $this->getModel();
        $model->delete($pks);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }
}