<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\AdminController;

class ReviewsController extends AdminController
{
    /**
     * @return Balbooa\Component\Gridbox\Administrator\Model
    */
    public function getModel($name = 'Reviews', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function getSettings()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $obj = new \stdClass();
        $obj->website = GridboxHelper::$website;
        $obj->users = $model->getUsers();
        $obj->commentsBanList = $model->getBannedReviewsLists();
        $obj->moderators = $obj->website->reviews_moderator_admins;
        $str = json_encode($obj);
        echo $str;
        exit();
    }

    public function saveCommentsOptions()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $str = $input->get('obj', '{}', 'raw');
        $obj = json_decode($str);
        $model = $this->getModel();
        $model->saveReviewsOptions($obj->website);
        $model->setCommetsBannedList($obj->commentsBannedList);
        GridboxHelper::ajaxReload('JLIB_APPLICATION_SAVE_SUCCESS');
    }

    public function banUser()
    {
        $input = Factory::getApplication()->input;
        $email = $input->get('email', '', 'string');
        $ip = $input->get('ip', '', 'string');
        $model = $this->getModel();
        $model->banUser($email, $ip);
        $msg = empty($email) && empty($ip) ? 'USER_CANNOT_BE_BANNED' : 'SUCCESSFULLY_BANNED';
        GridboxHelper::ajaxReload($msg);
    }

    public function sendCommentMesssage()
    {
        $input = Factory::getApplication()->input;
        $parent = $input->get('parent', 0, 'int');
        $message = $input->get('message', '', 'raw');
        $type = $input->get('type', 'reply', 'string');
        $attachments = $input->get('attachments', '{}', 'string');
        $files = json_decode($attachments);
        $model = $this->getModel();
        $model->sendReviewMesssage($parent, $message, $files, $type);
        if ($type != 'reply') {
            $attachments = GridboxHelper::getReviewAttachments($parent);
            $str = json_encode($attachments);
            echo $str;
        }
        exit();
    }

    public function removeTmpAttachment()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $filename = $input->get('filename', '', 'string');
        GridboxHelper::removeTmpReviewsAttachment($id, $filename);
        exit();
    }

    public function uploadAttachmentFile()
    {
        $input = Factory::getApplication()->input;
        $file = $input->files->get('file', [], 'array');
        $type = $input->post->get('type', 'file', 'string');
        $model = $this->getModel();
        $obj = $model->uploadAttachmentFile($file, $type);
        $str = json_encode($obj);
        echo $str;
        exit();
    }

    public function getCommentLikeStatus()
    {
        $model = $this->getModel();
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $status = $model->getReviewLikeStatus($id);
        echo $status;exit;
    }

    public function setLikes()
    {
        $model = $this->getModel();
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $action = $input->get('action', 'likes', 'string');
        $model->setLikes($id, $action);
        exit;
    }

    public function setReadStatus()
    {
        $model = $this->getModel();
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $model->setReadStatus($id);
        exit;
    }

    public function readAll()
    {
        $model = $this->getModel();
        $model->readAll();
        exit;
    }

    public function unread()
    {
        $cid = $this->input->get('cid', [], 'array');
        $model = $this->getModel();
        foreach ($cid as $id) {
            $model->setReadStatus($id, 1);
        }
        exit;
    }

    public function approve()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $model = $this->getModel();
        $model->approve($pks);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_APPROVED');
    }

    public function contextApprove()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $array = [$id];
        $model = $this->getModel();
        $model->approve($array);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_APPROVED');
    }

    public function spam()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $model = $this->getModel();
        $model->spam($pks);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_SPAMED');
    }

    public function contextSpam()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $array = [$id];
        $model = $this->getModel();
        $model->spam($array);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_SPAMED');
    }

    public function delete()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $model = $this->getModel();
        $model->delete($pks);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function contextDelete()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $array = [$id];
        $model = $this->getModel();
        $model->delete($array);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }
}