<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;

class ShippingController extends AdminController
{
    /**
     * @return Balbooa\Component\Gridbox\Administrator\Model
    */
    public function getModel($name = 'Shipping', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function updateShipping()
    {
        GridboxHelper::checkUserEditLevel();
        $post = $this->input->post->getArray([]);
        $data = (object)$post;
        $data->options = $this->input->get('options', '', 'raw');
        $model = $this->getModel();
        $model->updateShipping($data);
        $obj = new \stdClass();
        $obj->message = Text::_('JLIB_APPLICATION_SAVE_SUCCESS');
        $str = json_encode($obj);
        echo $str;
        exit;
    }

    public function getOptions()
    {
        $id = $this->input->get('id', 0, 'int');
        $model = $this->getModel();
        $obj = $model->getOptions($id);
        $str = json_encode($obj);
        echo $str;
        exit;
    }

    public function addShipping()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->addShipping();
        exit;
    }

    public function delete()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $model = $this->getModel();
        $model->delete($pks);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function contextDelete()
    {
        GridboxHelper::checkUserEditLevel();
        $id = $this->input->get('context-item', 0, 'int');
        $array = [$id];
        $model = $this->getModel();
        $model->delete($array);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function publish()
    {
        GridboxHelper::checkUserEditLevel();
        $task = $this->getTask();
        if ($task != 'unpublish') {
            $value = 1;
            $text = $this->text_prefix . '_N_ITEMS_PUBLISHED';
        } else {
            $value = 0;
            $text = $this->text_prefix . '_N_ITEMS_UNPUBLISHED';
        }
        $cid = Factory::getApplication()->input->get('cid', [], 'array');
        $model = $this->getModel();
        $model->publish($cid, $value);
        GridboxHelper::ajaxReload($text);
    }
}