<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;

class SubscriptionsController extends AdminController
{
    /**
     * @return Balbooa\Component\Gridbox\Administrator\Model
    */
    public function getModel($name = 'Subscriptions', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function setExpires()
    {
        $id = $this->input->get('id', 0, 'int');
        $expires = $this->input->get('expires', '', 'string');
        $model = $this->getModel();
        $obj = $model->setExpires($id, $expires);
        $obj->message = Text::_('JLIB_APPLICATION_SAVE_SUCCESS');
        $str = json_encode($obj);
        print_r($str);exit;
    }

    public function getSubscription()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('id', 0, 'int');
        $model = $this->getModel();
        $subscription = $model->getSubscription($id);
        $str = json_encode($subscription);
        print_r($str);exit;
    }

    public function setRenew()
    {
        $data = $this->input->get('data', '{}', 'string');
        $obj = json_decode($data);
        $model = $this->getModel();
        $model->setRenew($obj);
        print_r('{}');exit;
    }

    public function delete()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $model = $this->getModel();
        $model->delete($pks);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }
}