<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\Trait\BulkActionsControllerTrait;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\AdminController;

class SystemController extends AdminController
{
    use BulkActionsControllerTrait;

    public function getModel($name = 'System', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function applySettings()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->applySettings();
        GridboxHelper::ajaxReload('JLIB_APPLICATION_SAVE_SUCCESS');
    }

    public function restore()
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $id = $this->input->get('context-item', 0, 'int');
        $pks = [$id];
        $model->publish($pks, 1);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_RESTORED');
    }

    public function publish()
    {
        GridboxHelper::checkUserEditLevel();
        $task = $this->getTask();
        if ($task != 'unpublish') {
            $value = 1;
            $text = $this->text_prefix.'_N_ITEMS_PUBLISHED';
        } else {
            $value = 0;
            $text = $this->text_prefix.'_N_ITEMS_UNPUBLISHED';
        }
        $cid = Factory::getApplication()->input->get('cid', [], 'array');
        $model = $this->getModel();
        $model->publish($cid, $value);
        GridboxHelper::ajaxReload($text);
    }

    public function contextDuplicate()
    {
        GridboxHelper::checkUserEditLevel();
        $id = $this->input->get('context-item', 0, 'int');
        $pks = [$id];
        $model = $this->getModel();
        $model->duplicate($pks);
        GridboxHelper::ajaxReload('GRIDBOX_DUPLICATED');
    }

    public function duplicate()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $model = $this->getModel();
        $model->duplicate($pks);
        GridboxHelper::ajaxReload('GRIDBOX_DUPLICATED');
    }

    public function delete()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $model = $this->getModel();
        $model->delete($pks);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function contextDelete()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $model = $this->getModel();
        $model->delete([$id]);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function addTrash()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $model = $this->getModel();
        $model->trash($pks);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_TRASHED');
    }

    public function contextTrash()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $model = $this->getModel();
        $model->trash([$id]);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_TRASHED');
    }
}