<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Administrator\Model\TagsModel;
use Balbooa\Component\Gridbox\Administrator\Trait\BulkActionsControllerTrait;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\AdminController;

class TagsController extends AdminController
{
    use BulkActionsControllerTrait;

    public function getModel($name = 'Tags', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function move(): void
    {
        GridboxHelper::checkUserEditLevel();
        $id = $this->input->get('id', 0, 'int');
        $folder = $this->input->get('folder', 1, 'int');
        /** @var TagsModel $model */
        $model = $this->getModel();
        $model->move($id, $folder);
        GridboxHelper::ajaxReload('SUCCESS_MOVED');
    }

    public function moveTo()
    {
        GridboxHelper::checkUserEditLevel();
        $folder = $this->input->get('category_id', 1, 'int');
        $cid = $this->input->get('cid', [], 'array');
        /** @var TagsModel $model */
        $model = $this->getModel();
        foreach ($cid as $id) {
            $model->move($id, $folder);
        }
        GridboxHelper::ajaxReload('SUCCESS_MOVED');
    }

    public function renameFolder()
    {
        GridboxHelper::checkUserEditLevel();
        $id = $this->input->get('id', 0, 'int');
        $title = $this->input->get('title', '', 'string');
        /** @var TagsModel $model */
        $model = $this->getModel();
        $model->renameFolder($id, $title);
        exit();
    }

    public function deleteTagsFolder()
    {
        GridboxHelper::checkUserEditLevel();
        $id = $this->input->get('context-item', 0, 'int');
        /** @var TagsModel $model */
        $model = $this->getModel();
        $model->deleteTagsFolder($id);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function orderFolders()
    {
        GridboxHelper::checkUserEditLevel();
        $string = $this->input->get('data', '', 'raw');
        $data = json_decode($string);
        /** @var TagsModel $model */
        $model = $this->getModel();
        $model->orderFolders($data);
        exit();
    }

    public function createFolder()
    {
        $id = $this->input->get('id', 0, 'int');
        $title = $this->input->get('title', '', 'string');
        /** @var TagsModel $model */
        $model = $this->getModel();
        $model->createFolder($id, $title);
        GridboxHelper::ajaxReload('JLIB_APPLICATION_SAVE_SUCCESS');
    }

    public function updateTags()
    {
        GridboxHelper::checkUserEditLevel();
        /** @var TagsModel $model */
        $model = $this->getModel();
        $model->updateTags();
        GridboxHelper::ajaxReload('JLIB_APPLICATION_SAVE_SUCCESS');
    }

    public function addTag()
    {
        GridboxHelper::checkUserEditLevel();
        $title = $this->input->getVar('tag_name');
        $folder = $this->input->get('folder', 1, 'int');
        /** @var TagsModel $model */
        $model = $this->getModel();
        $obj = $model->addTag($title);
        if ($folder != 1) {
            $model->move($obj->id, $folder);
        }
        GridboxHelper::ajaxReload('ITEM_CREATED');
    }

    public function delete()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        /** @var TagsModel $model */
        $model = $this->getModel();
        $model->delete($pks);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function contextDelete()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $array = [];
        $array[] = $id;
        /** @var TagsModel $model */
        $model = $this->getModel();
        $model->delete($array);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function publish()
    {
        GridboxHelper::checkUserEditLevel();
        $task = $this->getTask();
        if ($task != 'unpublish') {
            $value = 1;
            $text = $this->text_prefix . '_N_ITEMS_PUBLISHED';
        } else {
            $value = 0;
            $text = $this->text_prefix . '_N_ITEMS_UNPUBLISHED';
        }
        $cid = $this->input->get('cid', [], 'array');
        /** @var TagsModel $model */
        $model = $this->getModel();
        $model->publish($cid, $value);
        GridboxHelper::ajaxReload($text);
    }

    public function contextDuplicate()
    {
        GridboxHelper::checkUserEditLevel();
        $id = $this->input->get('context-item', 0, 'int');
        $array = [];
        $array[] = $id;
        /** @var TagsModel $model */
        $model = $this->getModel();
        $model->duplicate($array);
        GridboxHelper::ajaxReload('GRIDBOX_DUPLICATED');
    }
    
    public function duplicate()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        /** @var TagsModel $model */
        $model = $this->getModel();
        $model->duplicate($pks);
        GridboxHelper::ajaxReload('GRIDBOX_DUPLICATED');
    }
}