<?php
/**
* @package   gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\Filesystem\File;
use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\AdminController;

class ThemesController extends AdminController
{
    public function getModel($name = 'Theme', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function contextDelete()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $array = [];
        $array[] = $id;
        $model = $this->getModel();
        $this->checkItems($array);
        $model->delete($array);
        GridboxHelper::deleteThemeCss($array);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
    }

    public function checkItems($cid)
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->checkItems($cid);
    }

    public function contextDuplicate()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $array = [];
        $array[] = $id;
        $model = $this->getModel();
        $model->duplicate($array);
        GridboxHelper::ajaxReload('GRIDBOX_DUPLICATED');
    }
    
    public function delete()
    {
        GridboxHelper::checkUserEditLevel();
        $cid = Factory::getApplication()->input->get('cid', [], 'array');
        $model = $this->getModel();
        $flag = true;
        foreach ($cid as $id) {
            $table = $model->getTable();
            $table->load($id);
            if ($table->home * 1 == 1) {
                $flag = false;
            }
        }
        if ($flag) {
            $this->checkItems($cid);
            parent::delete();
            GridboxHelper::deleteThemeCss($cid);
            GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
        } else {
            GridboxHelper::ajaxReload('CANT_DELETE_DEFAULT_THEME');
        }
    }
    
    public function duplicate()
    {
        GridboxHelper::checkUserEditLevel();
        $pks = $this->input->getVar('cid', [], 'post', 'array');
        $model = $this->getModel();
        $model->duplicate($pks);
        GridboxHelper::ajaxReload('GRIDBOX_DUPLICATED');
    }

    public function addNewTheme($xml)
    {
        GridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->addNewTheme($xml);
    }

    public function uploadTheme()
    {
        GridboxHelper::checkUserEditLevel();
        $msg = 'SUCCESS_UPLOAD';
        $file = $this->input->getVar('file', '', 'get', 'string');
        $config = Factory::getConfig();
        $name = $config->get('tmp_path') . '/' .$file;
        $userfile = $this->input->files->get('file', null, 'raw');
        File::upload($userfile['tmp_name'], $name, false, true);
        $xml = simplexml_load_file($name);
        $model = $this->getModel();
        $model->addNewTheme($xml);
        GridboxHelper::ajaxReload($msg, '');
    }

    public function downloadTheme()
    {
        GridboxHelper::checkUserEditLevel();
        $data = file_get_contents('php://input');
        $this->installTheme($data);
    }

    public function downloadThemePost()
    {
        GridboxHelper::checkUserEditLevel();
        $data = $_POST['data'];
        $this->installTheme($data);
    }

    public function downloadThemeCurl()
    {
        GridboxHelper::checkUserEditLevel();
        $url = $this->input->get('url', '', 'string');
        $data = GridboxHelper::getContentsCurl($url);
        $this->installTheme($data);
    }

    protected function installTheme($data)
    {
        if (!empty($data) && $xml = simplexml_load_string($data)) {
            $xml = simplexml_load_string($data);
            $model = $this->getModel();
            $model->addNewTheme($xml, true);
            $model->installGridboxApp('code-editor');
            GridboxHelper::ajaxReload('SUCCESS_UPLOAD');
        }
        exit;
    }
}