<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Controller;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Balbooa\Component\Gridbox\Site\Helper\AssetsHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;

class TrashedController extends AdminController
{
    /**
     * @return Balbooa\Component\Gridbox\Administrator\Model
    */
    public function getModel($name = 'Gridbox', $prefix = 'Administrator', $config = ['ignore_request' => true]) 
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function getCategories()
    {
        GridboxHelper::checkUserEditLevel();
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('id, title, type')
            ->from('#__gridbox_app')
            ->where('type <> '.$db->quote('system_apps'))
            ->order($db->escape('id ASC'));
        $db->setQuery($query);
        $obj = new \stdClass();
        $obj->id = 0;
        $obj->title = Text::_('PAGES');
        $obj->type = 'single';
        $items = array($obj);
        $apps = $db->loadObjectList();
        $items = array_merge($items, $apps);
        foreach ($items as $item) {
            $query = $db->getQuery(true)
                ->select('id, title')
                ->from('#__gridbox_categories')
                ->where('parent = 0')
                ->where('app_id = ' .$item->id);
            $db->setQuery($query);
            $item->categories = $db->loadObjectList();
            foreach ($item->categories as $value) {
                $value->child = $this->getAllChild($value, $item->id);
            }
        }
        $result = json_encode($items);
        echo $result;
        exit;
    }

    protected function getAllChild($parent, $id)
    {
        GridboxHelper::checkUserEditLevel();
        $db = Factory::getDbo();
        $query = $db->getQuery(true)
            ->select('*')
            ->from('#__gridbox_categories')
            ->where('`app_id` = '.$id)
            ->where('`parent` = '.$parent->id);
        $db->setQuery($query);
        $items = $db->loadObjectList();
        foreach ($items as $key => $value) {
            $value->child = $this->getAllChild($value, $id);
        }

        return $items;
    }

    public function contextDelete()
    {
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $assets = new AssetsHelper($id, 'page');
        $flag = $assets->checkPermission('core.delete');
        if ($flag) {
            $array = [$id];
            $model = $this->getModel();
            $model->delete($array);
            GridboxHelper::afterDeleteAction($array);
            GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
        } else {
            GridboxHelper::ajaxReload('JERROR_CORE_DELETE_NOT_PERMITTED');
        }
    }

    public function delete()
    {
        $cid = Factory::getApplication()->input->get('cid', [], 'array');
        $str = Factory::getApplication()->input->get('types', '', 'string');
        $types = explode(', ', $str);
        $flag = true;
        $user = Factory::getUser();
        $pages = [];
        $system = [];
        foreach ($cid as $key => $id) {
            $type = $types[$key];
            if ($type == 'system') {
                $system[] = $id;
                $flag = $user->authorise('core.delete', 'com_gridbox');
            } else {
                $pages[] = $id;
                $assets = new AssetsHelper($id, 'page');
                $flag = $assets->checkPermission('core.delete');
            }
            if (!$flag) {
                break;
            }
        }
        if ($flag) {
            $model = $this->getModel();
            $model->delete($pages);
            $model = $this->getModel('system');
            $model->delete($system);
            GridboxHelper::afterDeleteAction($pages);
            GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_DELETED');
        } else {
            GridboxHelper::ajaxReload('JERROR_CORE_DELETE_NOT_PERMITTED');
        }
    }

    public function restoreSingle()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $category = $input->get('category_id', '', 'string');
        $model = $this->getModel();
        $model->moveSingle($id, $category);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_RESTORED');
    }

    public function restoreBlog()
    {
        GridboxHelper::checkUserEditLevel();
        $input = Factory::getApplication()->input;
        $id = $input->get('context-item', 0, 'int');
        $category = $input->get('category_id', '', 'string');
        $obj = json_decode($category);
        $model = $this->getModel('category');
        $model->pageMoveTo($obj->id, $id, $obj->app_id);
        GridboxHelper::ajaxReload('COM_GRIDBOX_N_ITEMS_RESTORED');
    }
}