<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Field;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

class CreateField extends ListField
{
    protected $type = 'create';
    
    protected function getInput()
    {
        $app = Factory::getApplication();
        $db = Factory::getDbo();
        $doc = Factory::getDocument();
        if ($this->value === 0 || $this->value === '0') {
            $title = Text::_('PAGES');
        } else {
            $query = $db->getQuery(true)
                ->select($db->quoteName('title'))
                ->from($db->quoteName('#__gridbox_app'))
                ->where($db->quoteName('id').' = '.(int)$this->value);
            $db->setQuery($query);
            $title = $db->loadResult();
        }
        if (!empty($title)) {
            $title = htmlspecialchars($title, ENT_QUOTES, 'UTF-8');
        }
        $iframe = 'index.php?option=com_gridbox&view=pages&layout=apps&edit_type=create&tmpl=component';
        include JPATH_ROOT.'/administrator/components/com_gridbox/tmpl/layouts/submit-new-item.php';
        $html = $out;
        $html .= GridboxHelper::renderBootstrapModal('gridbox-app-modal', 'APP', $iframe);
        $doc->addScript(Uri::root().'media/vendor/jquery/js/jquery.min.js');
        
        return $html;
    }
}