<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Field;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Uri\Uri;

class SystemField extends ListField
{
    protected $type = 'system';
    
    protected function getInput()
    {
        $app = Factory::getApplication();
        $db = Factory::getDbo();
        $doc = Factory::getDocument();
        $query = $db->getQuery(true)
            ->select($db->quoteName('title'))
            ->from($db->quoteName('#__gridbox_app'))
            ->where($db->quoteName('id').' = '.(int)$this->value);
        $db->setQuery($query);
        $title = $db->loadResult() ?? '';
        $title = htmlspecialchars($title, ENT_QUOTES, 'UTF-8');
        $iframe = 'index.php?option=com_gridbox&view=system&layout=modal&tmpl=component';
        include JPATH_ROOT.'/administrator/components/com_gridbox/tmpl/layouts/submission-form-menu.php';
        $html = $out;
        $html .= GridboxHelper::renderBootstrapModal('gridbox-app-modal', 'PAGE', $iframe);
        $doc->addScript(Uri::root().'media/vendor/jquery/js/jquery.min.js');
        
        return $html;
    }
}