<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\ListModel;
use Balbooa\Component\Gridbox\Site\Helper\FileHelper;
use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;

class DashboardModel extends ListModel
{
    private $widgets;
    private $component_path = JPATH_ROOT . '/administrator/components/com_gridbox/';

    public function __construct($config = [])
    {
        $path = $this->component_path . 'assets/json/dashboard-widgets-list.json';
        $this->widgets = $this->loadWidgetsFromFile($path);;
        foreach ($this->widgets as $widget) {
            $widget->title = Text::_($widget->title);
        }


        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = [
                'id', 'title', 'state'
            ];
        }
        parent::__construct($config);
    }

    public function renderWidget($widget, $ind)
    {
        ob_start();
        include $this->component_path . 'tmpl/dashboard/'
            . $widget->type . '.php';

        return ob_get_clean();
    }

    public function loadWidgetsFromFile(string $path)
    {
        $fileConten = FileHelper::readFile($path);
        
        return json_decode($fileConten);
    }

    public function saveDashboard(object $dashboard):void
    {
        $api = GridboxHelper::getGridboxApi('dashboard');
        $db = Factory::getDbo();
        $key = json_encode($dashboard);
        if (!$api) {
            $api = (object)[
                'service' => 'dashboard',
                'key' => $key
            ];
            $db->insertObject('#__gridbox_api', $api);
        } else {
            $api->key = $key;
            $db->updateObject('#__gridbox_api', $api, 'id');
        }
    }

    public function getDashboard()
    {
        $dashboard_api = GridboxHelper::getGridboxApi('dashboard');
        if ($dashboard_api && ($dashboard = json_decode($dashboard_api->key))) {
            return $dashboard;
        }
        $path = $this->component_path . 'assets/json/dashboard.json';
        $dashboard = $this->loadWidgetsFromFile($path);
        foreach ($dashboard->widgets as $widget) {
            $widget->title = $this->widgets->{$widget->type}->title;
        }

        return $dashboard;
    }

    public function getWidgetObject(string $type, string $icon):object
    {
        return (object)[
            'title' => $this->widgets->{$type}->title,
            'icon' => $icon
        ];
    }

    public function getWidgets():array
    {
        $widgets = [
            'apps' => $this->getWidgetObject('apps', 'zmdi zmdi-widgets'),
            'booking' => $this->getWidgetObject('booking', 'zmdi zmdi-calendar-note'),
            'comments' => $this->getWidgetObject('comments', 'zmdi zmdi-comment-more'),
            'files' => $this->getWidgetObject('files', 'zmdi zmdi-folder'),
            'pages' => $this->getWidgetObject('pages', 'zmdi zmdi-file'),
            'links' => $this->getWidgetObject('links', 'zmdi zmdi-link'),
            'reviews' => $this->getWidgetObject('reviews', 'zmdi zmdi-ticket-star'),
            'sales' => $this->getWidgetObject('sales', 'zmdi zmdi-trending-up')
        ];
        
        return $widgets;
    }

    public function getAllWidgets()
    {
        return $this->widgets;
    }

    public function setFilters()
    {
        $this->populateState();
    }

    protected function getStoreId($id = '')
    {
        $id .= ':' . $this->getState('filter.search');
        $id .= ':' . $this->getState('filter.published');
        return parent::getStoreId($id);
    }
    
    protected function populateState($ordering = null, $direction = null)
    {
        $search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);
        $published = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);
        parent::populateState('id', 'desc');
    }
    
}