<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\ListModel;

class TrashedModel extends ListModel
{
    public function __construct($config = [])
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(
                'id', 'app_id', 'published', 'theme', 'title', 'hits'
            );
        }
        parent::__construct($config);
    }

    public function setFilters()
    {
        $this->populateState();
    }
    
    protected function getListQuery()
    {
        $app = Factory::getApplication();
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id, title, theme, app_id, hits, language')
            ->from('#__gridbox_pages')
            ->where('`page_category` ='.$db->quote('trashed'));
        $q2 = $db->getQuery(true)
            ->select('id, title, theme, type AS app_id, published AS hits, language')
            ->from('#__gridbox_system_pages')
            ->where('published = -1');
        $search = $this->getState('filter.search');
        if (!empty($search)) {
            $search = $db->quote('%' . $db->escape($search, true) . '%', false);
            $query->where('title LIKE ' . $search);
            $q2->where('title LIKE ' . $search);
        }
        $language = $this->getState('filter.language');
        if (!empty($language)) {
            $query->where('language = '.$db->quote($language));
            $q2->where('language = '.$db->quote($language));
        }
        $app = $this->getState('filter.app');
        if (!empty($app)) {
            $query->where('app_id = '.$db->quote($app));
        }
        $orderCol = $this->state->get('list.ordering', 'id');
		$orderDirn = $this->state->get('list.direction', 'desc');
		$query->order($db->escape($orderCol.' '.$orderDirn));
        $q2->order($db->escape($orderCol.' '.$orderDirn));
        $query->unionAll($q2);
        
        return $query;
    }

    public function getItems()
    {
        $store = $this->getStoreId();
        $app = Factory::getApplication();
        if (isset($this->cache[$store])) {
            return $this->cache[$store];
        }
        $query = $this->_getListQuery();
        try {
            if ($app->input->get('layout') == 'modal') {
                $items = $this->_getList($query, 0, 0);
            } else {
                $items = $this->_getList($query, $this->getStart(), $this->getState('list.limit'));
            }
            $db = Factory::getDbo();
            foreach ($items as $item) {
                $query = $db->getQuery(true);
                $query->select('title')
                    ->from('#__template_styles')
                    ->where('id = '.$db->quote($item->theme));
                $db->setQuery($query);
                $item->themeName = $db->loadResult();
                if ($item->hits == -1) {
                    $item->app_name = '';
                    $item->app_type = 'system';
                } else if ($item->app_id == 0) {
                    $item->app_name = Text::_('PAGES');
                    $item->app_type = 'single';
                } else {
                    $query = $db->getQuery(true);
                    $query->select('title, type')
                        ->from('#__gridbox_app')
                        ->where('id = '.$db->quote($item->app_id));
                    $db->setQuery($query);
                    $result = $db->loadObject();
                    $item->app_type = $result->type;
                    $item->app_name = $result->title;
                }
            }
        } catch (\RuntimeException $e) {
            $this->setError($e->getMessage());
            return false;
        }
        $this->cache[$store] = $items;

        return $this->cache[$store];
    }

    public function getThemes()
    {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id, title')
            ->from('#__template_styles')
            ->where('`template` = ' .$db->Quote('gridbox'));
        $db->setQuery($query);
        
        return $db->loadObjectList();
    }
    
    protected function getStoreId($id = '')
    {
        $id .= ':' . $this->getState('filter.search');
        return parent::getStoreId($id);
    }
    
    protected function populateState($ordering = null, $direction = null)
    {
        $search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);
        $language = $this->getUserStateFromRequest($this->context . '.filter.language', 'language_filter', '', 'string');
        $this->setState('filter.language', $language);
        $app = $this->getUserStateFromRequest($this->context . '.filter.app', 'filter_state', '', 'string');
        $this->setState('filter.app', $app);
        parent::populateState('id', 'desc');
    }
}