<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Table;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Filter\OutputFilter;
use Joomla\CMS\Table\Table;

class CategoriesTable extends Table
{
    public function __construct(&$db)
	{
		parent::__construct('#__gridbox_categories', 'id', $db);
	}

	public function check()
    {
        if (empty($this->alias)) {
            $this->alias = $this->title;
        }
        $originAlias = $this->alias;
        $this->alias = OutputFilter::stringURLSafe(trim($this->alias));
        if (empty($this->alias)) {
            $this->alias = $originAlias;
            $this->alias = GridboxHelper::replace($this->alias);
            $this->alias = OutputFilter::stringURLSafe($this->alias);
        }
        if (empty($this->alias)) {
            $this->alias = date('Y-m-d-H-i-s');
        }
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id')
            ->from('#__gridbox_categories')
            ->where('`alias` = ' .$db->Quote($this->alias))
            ->where('`id` <> '.$this->id);
        $db->setQuery($query);
        $id = $db->loadResult();
        if (!empty($id)) {
            return false;
        }
        
        return true;
    }
}
