<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Balbooa\Component\Gridbox\Administrator\Table;

defined('_JEXEC') or die;

use Balbooa\Component\Gridbox\Administrator\Helper\GridboxHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Filter\OutputFilter;
use Joomla\CMS\Table\Table;

class PagesTable extends Table
{
    public function __construct(&$db)
    {
        parent::__construct('#__gridbox_pages', 'id', $db);
    }

    public function check()
    {
        if (empty($this->page_alias)) {
            $this->page_alias = $this->title;
        }
        $pk = $this->id;
        if (empty($pk)) {
            $pk = 0;
        }
        $originAlias = $this->page_alias;
        $this->page_alias = GridboxHelper::stringURLSafe(trim($this->page_alias));
        if (empty($this->page_alias)) {
            $this->page_alias = $originAlias;
            $this->page_alias = GridboxHelper::replace($this->page_alias);
            $this->page_alias = OutputFilter::stringURLSafe($this->page_alias);
        }
        if (empty($this->page_alias)) {
            $this->page_alias = date('Y-m-d-H-i-s');
        }
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id')
            ->from('#__gridbox_pages')
            ->where('`page_alias` = ' .$db->Quote($this->page_alias))
            ->where('`id` <> '.$pk);
        $db->setQuery($query);
        $id = $db->loadResult();
        if (!empty($id)) {
            return false;
        }
        
        return true;
    }
}
